/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.drivers.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.ifaces.protocol.Protocol;
import org.ametiste.ifaces.protocol.http.HttpProtocolMessage;
import org.ametiste.sns.client.drivers.ReportMessage;

public class RestfulReportCreationProtocol
implements Protocol<ReportMessage, HttpProtocolMessage<Map<String, Object>>> {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final String relativePath;

    public RestfulReportCreationProtocol(String relativePath) {
        this.headers.put("Content-Type", Collections.singletonList("application/json"));
        this.headers.put("Accept", Collections.singletonList("application/json"));
        this.relativePath = relativePath;
    }

    public HttpProtocolMessage<Map<String, Object>> buildMessage(ReportMessage message) {
        HashMap<String, Object> reportRequest = new HashMap<String, Object>();
        reportRequest.put("id", message.getReportId().toString());
        reportRequest.put("date", message.getDate().getTime());
        reportRequest.put("type", message.getType());
        reportRequest.put("sender", message.getSender());
        reportRequest.put("content", message.getContent());
        HttpProtocolMessage httpProtocolMessage = new HttpProtocolMessage("PUT", "/" + this.relativePath + message.getReportId().toString(), this.headers, null, reportRequest);
        return httpProtocolMessage;
    }
}

