/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.drivers.multithread;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ametiste.metrics.annotations.Countable;
import org.ametiste.sns.client.drivers.ReportServiceDriver;
import org.ametiste.sns.client.drivers.multithread.NamedThreadFactory;
import org.ametiste.sns.client.drivers.multithread.ReportRunner;
import org.ametiste.sns.client.model.Report;

public class LimitableThreadPoolWrapperDriver
implements ReportServiceDriver {
    private final ExecutorService executor;
    private final ReportServiceDriver driver;
    private String snsNamespace;

    public LimitableThreadPoolWrapperDriver(ReportServiceDriver driver, String threadName, String snsNamespace, int threadsNumber, int queueCapacity) {
        this.driver = driver;
        this.snsNamespace = snsNamespace;
        this.executor = new ThreadPoolExecutor(threadsNumber, threadsNumber, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(threadName));
    }

    @Override
    @Countable(nameSuffixExpression="target.getSnsNamespace() + '.reports.count'")
    public void createNewReport(UUID reportId, Date date, String reportType, String reportSender, Serializable reportContent) {
        Report report = new Report(reportId, date, reportType, reportSender, reportContent);
        this.executor.execute(new ReportRunner(this.driver, report));
    }

    public String getSnsNamespace() {
        return this.snsNamespace;
    }
}

