/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.drivers;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametiste.ifaces.protocol.Protocol;
import org.ametiste.ifaces.protocol.http.HttpProtocolMessage;
import org.ametiste.sns.client.drivers.ReportMessage;
import org.ametiste.sns.client.drivers.ReportServiceDriver;
import org.ametiste.sns.client.drivers.UnsupportedMethodException;
import org.ametiste.sns.client.drivers.protocol.RestfulReportCreationProtocol;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SnsReportRESTfulServiceDriver
implements ReportServiceDriver {
    public static final String DEFAULT_SERVICE_HOST = "localhost";
    public static final RestfulReportCreationProtocol DEFAULT_PROTOCOL = new RestfulReportCreationProtocol("");
    private final RestTemplate restTemplate;
    private final String serviceHost;
    private final Protocol<ReportMessage, HttpProtocolMessage<Map<String, Object>>> protocol;

    public SnsReportRESTfulServiceDriver(String serviceHost, RestTemplate restTemplate, Protocol<ReportMessage, HttpProtocolMessage<Map<String, Object>>> protocol) {
        if (serviceHost == null) {
            throw new IllegalArgumentException("Service host can't be null.");
        }
        if (restTemplate == null) {
            throw new IllegalArgumentException("RestTemplate can't be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol can't be null.");
        }
        this.serviceHost = serviceHost;
        this.restTemplate = restTemplate;
        this.protocol = protocol;
    }

    public SnsReportRESTfulServiceDriver(RestTemplate restTemplate) {
        this(DEFAULT_SERVICE_HOST, restTemplate, DEFAULT_PROTOCOL);
    }

    @Override
    public void createNewReport(UUID reportId, Date date, String reportType, String reportSender, Serializable reportContent) {
        ReportMessage reportMessage = new ReportMessage(reportId, date, reportType, reportSender, reportContent);
        HttpProtocolMessage protocolMessage = (HttpProtocolMessage)this.protocol.buildMessage((Object)reportMessage);
        if (!protocolMessage.getMethod().equals("PUT")) {
            throw new UnsupportedMethodException("Illegal method exception.");
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Map.Entry header : protocolMessage.getHeaders().entrySet()) {
            for (String value : (List)header.getValue()) {
                httpHeaders.add((String)header.getKey(), value);
            }
        }
        HttpEntity requestEntity = new HttpEntity(protocolMessage.getBody(), (MultiValueMap)httpHeaders);
        this.restTemplate.put("http://" + this.serviceHost + protocolMessage.getPath(), (Object)requestEntity, new Object[0]);
    }
}

