/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.creators.injectors.support.report;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.ametiste.sns.client.creators.injectors.DataInjector;
import org.ametiste.sns.client.creators.injectors.model.ReportData;
import org.ametiste.sns.data.content.templates.HttpRequestContentTemplate;
import org.apache.commons.lang.exception.ExceptionUtils;

public class HttpRequestReportData
implements ReportData {
    private final UUID reportId;
    private final HttpServletRequest request;
    private Throwable reason;

    public HttpRequestReportData(UUID reportId, HttpServletRequest request) {
        this.reportId = reportId;
        this.request = request;
        this.reason = null;
    }

    public HttpRequestReportData(UUID reportId, HttpServletRequest request, Throwable reason) {
        this.reportId = reportId;
        this.request = request;
        this.reason = reason;
    }

    @Override
    public void inject(DataInjector injector) {
        injector.injectType("com.dph.reports.content.contrib.HttpRequestContent").injectId(this.reportId);
        HttpRequestContentTemplate.createContentFromRequest(this.request).entrySet().forEach(entry -> injector.injectContextEntry((String)entry.getKey(), entry.getValue()));
        if (this.reason != null) {
            injector.injectContextEntry("stacktrace", ExceptionUtils.getStackTrace((Throwable)this.reason)).injectContextEntry("errorClass", this.reason.getClass());
        }
    }
}

