/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.creators.injectors.model;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.ametiste.sns.client.creators.injectors.DataInjector;
import org.ametiste.sns.client.creators.injectors.EnvironmentInjector;
import org.ametiste.sns.client.model.Report;

public class ReportBuilder
implements DataInjector,
EnvironmentInjector {
    private UUID id;
    private String type;
    private Date date;
    private String sender;
    private HashMap<String, Object> context = new HashMap();

    @Override
    public ReportBuilder injectId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    public ReportBuilder injectType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public ReportBuilder injectContextEntry(String name, Object value) {
        if (this.context.containsKey(name)) {
            throw new IllegalArgumentException("Context already has entry with name: " + name + ". Check configuration and build flow");
        }
        this.context.put(name, value);
        return this;
    }

    @Override
    public ReportBuilder injectDate(Date date) {
        this.date = date;
        return this;
    }

    @Override
    public ReportBuilder injectSender(String sender) {
        this.sender = sender;
        return this;
    }

    public Report buildReport() {
        if (this.id == null) {
            throw new IllegalArgumentException("Id isnt injected. Report cant be built, since build isnt finished. Check configuration and build flow");
        }
        if (this.date == null) {
            throw new IllegalArgumentException("Date isnt injected. Report cant be built, since build isnt finished. Check configuration and build flow");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Type isnt injected. Report cant be built, since build isnt finished. Check configuration and build flow");
        }
        if (this.sender == null) {
            throw new IllegalArgumentException("Sender isnt injected. Report cant be built, since build isnt finished. Check configuration and build flow");
        }
        return new Report(this.id, this.date, this.type, this.sender, this.context);
    }
}

