/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.creators;

import java.util.List;
import org.ametiste.sns.client.creators.ReportErrorMode;
import org.ametiste.sns.client.creators.injectors.model.EnvironmentData;
import org.ametiste.sns.client.creators.injectors.model.ReportBuilder;
import org.ametiste.sns.client.creators.injectors.model.ReportData;
import org.ametiste.sns.client.drivers.ReportServiceDriver;
import org.ametiste.sns.client.model.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectingReportCreator {
    private final ReportServiceDriver driver;
    private List<EnvironmentData> environments;
    private final ReportErrorMode mode;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public InjectingReportCreator(ReportServiceDriver driver, List<EnvironmentData> environments, ReportErrorMode mode) {
        this.mode = mode;
        if (driver == null) {
            throw new IllegalArgumentException("ReportServiceDriver can't be null.");
        }
        if (environments == null) {
            throw new IllegalArgumentException("Environment data should be set. Can't be null.");
        }
        this.driver = driver;
        this.environments = environments;
    }

    public InjectingReportCreator(ReportServiceDriver driver, List<EnvironmentData> environments) {
        if (driver == null) {
            throw new IllegalArgumentException("ReportServiceDriver can't be null.");
        }
        if (environments == null) {
            throw new IllegalArgumentException("Environment data should be set. Can't be null.");
        }
        this.driver = driver;
        this.environments = environments;
        this.mode = ReportErrorMode.SILENT;
    }

    public void createReport(ReportData data) {
        ReportBuilder reportBuilder = new ReportBuilder();
        data.inject(reportBuilder);
        for (EnvironmentData environment : this.environments) {
            environment.inject(reportBuilder);
        }
        Report report = reportBuilder.buildReport();
        try {
            this.driver.createNewReport(report.getReportId(), report.getDate(), report.getReportType(), report.getReportSender(), report.getReportContent());
        }
        catch (Exception e) {
            if (this.mode.equals((Object)ReportErrorMode.STRICT)) {
                throw e;
            }
            this.logger.debug("Report error mode is silent. Ignoring report sending error: ", (Throwable)e);
        }
    }
}

