/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.data.event;

import java.net.URI;
import java.util.UUID;
import org.ametiste.scm.messaging.data.event.Event;
import org.apache.commons.lang3.Validate;

public class InstanceShutdownEvent
extends Event {
    private final String instanceId;
    private final String version;
    private final String nodeId;
    private final URI uri;

    private InstanceShutdownEvent(Builder builder) {
        this.instanceId = builder.instanceId;
        this.version = builder.version;
        this.nodeId = builder.nodeId;
        this.uri = builder.uri;
    }

    private InstanceShutdownEvent(UUID id, long timestamp, Builder builder) {
        super(id, timestamp);
        this.instanceId = builder.instanceId;
        this.version = builder.version;
        this.nodeId = builder.nodeId;
        this.uri = builder.uri;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UUID id;
        private long timestamp;
        private String instanceId;
        private String version;
        private String nodeId;
        private URI uri;

        private Builder() {
        }

        public Builder addId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder addTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder addInstanceId(String id) {
            this.instanceId = id;
            return this;
        }

        public Builder addVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder addNodeId(String id) {
            this.nodeId = id;
            return this;
        }

        public Builder addUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public InstanceShutdownEvent build() {
            Validate.validState((this.instanceId != null ? 1 : 0) != 0, (String)"'instanceId' must be initialized before event creation", (Object[])new Object[0]);
            Validate.validState((this.version != null ? 1 : 0) != 0, (String)"'version' must be initialized before event creation", (Object[])new Object[0]);
            Validate.validState((!this.version.isEmpty() ? 1 : 0) != 0, (String)"'version' must be not empty string", (Object[])new Object[0]);
            if (this.id != null && this.timestamp > 0L) {
                return new InstanceShutdownEvent(this.id, this.timestamp, this);
            }
            return new InstanceShutdownEvent(this);
        }
    }
}

