/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.data.event;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ametiste.scm.messaging.data.event.Event;
import org.apache.commons.lang3.Validate;

public class InstanceLifecycleEvent
extends Event {
    private final Type type;
    private final String instanceId;
    private final String version;
    private final Map<String, Object> properties;
    private final String nodeId;
    private final URI uri;

    private InstanceLifecycleEvent(Builder builder) {
        this.type = builder.type;
        this.instanceId = builder.instanceId;
        this.version = builder.version;
        this.properties = Collections.unmodifiableMap(builder.properties);
        this.nodeId = builder.nodeId;
        this.uri = builder.uri;
    }

    private InstanceLifecycleEvent(UUID id, long timestamp, Builder builder) {
        super(id, timestamp);
        this.type = builder.type;
        this.instanceId = builder.instanceId;
        this.version = builder.version;
        this.properties = Collections.unmodifiableMap(builder.properties);
        this.nodeId = builder.nodeId;
        this.uri = builder.uri;
    }

    public Type getType() {
        return this.type;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Type {
        STARTUP,
        SHUTDOWN;

    }

    public static class Builder {
        private Type type;
        private UUID id;
        private long timestamp;
        private String instanceId;
        private String version;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private String nodeId;
        private URI uri;

        private Builder() {
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder instanceId(String id) {
            this.instanceId = id;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder property(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder nodeId(String id) {
            this.nodeId = id;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public InstanceLifecycleEvent build() {
            Validate.validState((this.type != null ? 1 : 0) != 0, (String)"'type' must be initialized before event creation", (Object[])new Object[0]);
            Validate.validState((this.instanceId != null ? 1 : 0) != 0, (String)"'instanceId' must be initialized before event creation", (Object[])new Object[0]);
            Validate.validState((this.version != null ? 1 : 0) != 0, (String)"'version' must be initialized before event creation", (Object[])new Object[0]);
            Validate.validState((!this.version.isEmpty() ? 1 : 0) != 0, (String)"'version' must be not empty string", (Object[])new Object[0]);
            if (this.id != null && this.timestamp > 0L) {
                return new InstanceLifecycleEvent(this.id, this.timestamp, this);
            }
            return new InstanceLifecycleEvent(this);
        }
    }
}

