/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.data.event;

import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.Validate;

public abstract class Event
implements Serializable {
    private static final long serialVersionUID = 19L;
    private final UUID id;
    private final long timestamp;

    public Event() {
        this(UUID.randomUUID());
    }

    public Event(UUID id) {
        this(id, System.currentTimeMillis());
    }

    public Event(UUID id, long timestamp) {
        Validate.isTrue((id != null ? 1 : 0) != 0, (String)"'id' must be initialized", (Object[])new Object[0]);
        Validate.isTrue((timestamp > 0L ? 1 : 0) != 0, (String)"'timestamp' must be a positive number: %d", (long)timestamp);
        this.id = id;
        this.timestamp = timestamp;
    }

    public UUID getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

