/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.data.transport;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Validate;

public class TransportMessage<T>
implements Serializable {
    private static final long serialVersionUID = 19L;
    private final T source;
    private final Collection<URI> excludes;

    public TransportMessage() {
        this.source = null;
        this.excludes = Collections.emptyList();
    }

    public TransportMessage(T source) {
        this(source, Collections.emptyList());
    }

    public TransportMessage(T source, Collection<URI> excludes) {
        Validate.isTrue((source != null ? 1 : 0) != 0, (String)"'source' must be initialized", (Object[])new Object[0]);
        Validate.isTrue((excludes != null ? 1 : 0) != 0, (String)"'excludes' must be initialized", (Object[])new Object[0]);
        this.source = source;
        this.excludes = excludes;
    }

    public T getSource() {
        return this.source;
    }

    public Collection<URI> getExcludes() {
        return this.excludes;
    }
}

