/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.transport.http.dto;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ametiste.scm.messaging.data.event.Event;
import org.ametiste.scm.messaging.data.event.InstanceLifecycleEvent;
import org.ametiste.scm.messaging.transport.http.dto.EventDTO;
import org.apache.commons.lang3.Validate;

public class InstanceLifecycleEventDTO
extends EventDTO {
    private final InstanceLifecycleEvent.Type type;
    private final String instanceId;
    private final String version;
    private final Map<String, Object> properties;
    private final String nodeId;
    private final URI uri;

    private InstanceLifecycleEventDTO(Builder builder) {
        super(builder.id, builder.timestamp);
        this.type = builder.type;
        this.instanceId = builder.instanceId;
        this.version = builder.version;
        this.properties = Collections.unmodifiableMap(builder.properties);
        this.nodeId = builder.nodeId;
        this.uri = builder.uri;
    }

    public InstanceLifecycleEventDTO() {
        this.type = null;
        this.instanceId = null;
        this.version = null;
        this.properties = Collections.emptyMap();
        this.nodeId = null;
        this.uri = null;
    }

    public InstanceLifecycleEventDTO(InstanceLifecycleEvent event) {
        super((Event)event);
        this.type = event.getType();
        this.instanceId = event.getInstanceId();
        this.version = event.getVersion();
        this.properties = event.getProperties();
        this.nodeId = event.getNodeId();
        this.uri = event.getUri();
    }

    public InstanceLifecycleEvent.Type getType() {
        return this.type;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Event convert() {
        return InstanceLifecycleEvent.builder().type(this.type).id(super.getId()).timestamp(super.getTimestamp()).instanceId(this.instanceId).version(this.version).properties(this.properties).nodeId(this.nodeId).uri(this.uri).build();
    }

    @JsonPOJOBuilder(withPrefix="add")
    public static class Builder {
        private InstanceLifecycleEvent.Type type;
        private UUID id;
        private long timestamp;
        private String instanceId;
        private String version;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private String nodeId;
        private URI uri;

        public Builder addType(InstanceLifecycleEvent.Type type) {
            this.type = type;
            return this;
        }

        public Builder addId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder addTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder addInstanceId(String id) {
            this.instanceId = id;
            return this;
        }

        public Builder addVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder addNodeId(String id) {
            this.nodeId = id;
            return this;
        }

        public Builder addUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public InstanceLifecycleEventDTO build() {
            Validate.validState((this.type != null ? 1 : 0) != 0, (String)"'type' must be initialized before DTO creation", (Object[])new Object[0]);
            Validate.validState((this.id != null ? 1 : 0) != 0, (String)"'id' must be initialized before DTO creation", (Object[])new Object[0]);
            Validate.validState((this.timestamp > 0L ? 1 : 0) != 0, (String)"'timestamp' must be initialized before DTO creation", (Object[])new Object[0]);
            Validate.validState((this.instanceId != null ? 1 : 0) != 0, (String)"'instanceId' must be initialized before DTO creation", (Object[])new Object[0]);
            Validate.validState((this.version != null ? 1 : 0) != 0, (String)"'version' must be initialized before DTO creation", (Object[])new Object[0]);
            Validate.validState((!this.version.isEmpty() ? 1 : 0) != 0, (String)"'version' must be not empty string", (Object[])new Object[0]);
            return new InstanceLifecycleEventDTO(this);
        }
    }
}

