/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametiste.scm.messaging.data.event.Event;
import org.ametiste.scm.messaging.data.transport.TransportMessage;
import org.ametiste.scm.messaging.sender.EventSendException;
import org.ametiste.scm.messaging.sender.EventSender;
import org.ametiste.scm.messaging.transport.http.dto.EventDTO;
import org.ametiste.scm.messaging.transport.http.dto.EventDTOMessage;
import org.ametiste.scm.messaging.transport.http.dto.factory.DefaultEventToConverterMapFactory;
import org.ametiste.scm.messaging.transport.http.dto.factory.EventDTOFactory;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpEventSender
implements EventSender {
    private static final ResponseHandler RESPONSE_HANDLER = new BasicResponseHandler();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final HttpClient client;
    private final Map<Class, EventDTOFactory> eventConverterMap;

    public HttpEventSender(HttpClient client) {
        this(client, new DefaultEventToConverterMapFactory().getMap());
    }

    public HttpEventSender(HttpClient client, Map<Class, EventDTOFactory> eventConverterMap) {
        Validate.isTrue((client != null ? 1 : 0) != 0, (String)"'client' must be initialized", (Object[])new Object[0]);
        Validate.isTrue((eventConverterMap != null ? 1 : 0) != 0, (String)"'convertersMapFactory' must be initialized", (Object[])new Object[0]);
        this.client = client;
        this.eventConverterMap = eventConverterMap;
    }

    @Override
    public void send(URI receiver, TransportMessage<Event> message) throws EventSendException {
        this.send(receiver, Collections.singleton(message));
    }

    @Override
    public void send(URI receiver, Collection<TransportMessage<Event>> messages) throws EventSendException {
        List bulk = messages.stream().filter(eventMessage -> !eventMessage.getExcludes().contains(receiver)).map(m -> new EventDTOMessage(this.mapToDto((Event)m.getSource()), m.getExcludes())).collect(Collectors.toList());
        if (!bulk.isEmpty()) {
            this.execute(receiver, bulk);
        }
    }

    public static CloseableHttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build();
        return HttpClients.custom().setDefaultRequestConfig(config).build();
    }

    private void execute(URI receiver, Object message) throws EventSendException {
        HttpPost request = new HttpPost(receiver);
        request.setEntity((HttpEntity)new StringEntity(this.serialize(message), ContentType.APPLICATION_JSON));
        try {
            this.client.execute((HttpUriRequest)request, RESPONSE_HANDLER);
        }
        catch (IOException e) {
            throw new EventSendException(e.getMessage(), e);
        }
    }

    private String serialize(Object message) throws EventSendException {
        try {
            return MAPPER.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            throw new EventSendException(e.getMessage(), e);
        }
    }

    private EventDTO mapToDto(Event event) throws EventSendException {
        if (!this.eventConverterMap.containsKey(event.getClass())) {
            throw new EventSendException("Can't map event to DTO. Not registered event type.");
        }
        return this.eventConverterMap.get(event.getClass()).createDTO(event);
    }
}

