/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client;

import java.net.URI;
import org.ametiste.scm.messaging.data.transport.TransportMessage;
import org.ametiste.scm.messaging.sender.EventSender;
import org.ametiste.scm.messaging.sender.client.event.EventFactory;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSenderClient {
    private final Logger logger = LoggerFactory.getLogger(EventSenderClient.class);
    private final EventFactory factory;
    private final EventSender sender;
    private final URI target;
    private final boolean isStrict;

    public EventSenderClient(EventFactory factory, EventSender sender, URI target, boolean isStrict) {
        Validate.isTrue((factory != null ? 1 : 0) != 0, (String)"'factory' must be initialized", (Object[])new Object[0]);
        Validate.isTrue((sender != null ? 1 : 0) != 0, (String)"'sender' must be initialized", (Object[])new Object[0]);
        Validate.isTrue((target != null ? 1 : 0) != 0, (String)"'target' must be initialized", (Object[])new Object[0]);
        this.factory = factory;
        this.sender = sender;
        this.target = target;
        this.isStrict = isStrict;
    }

    public void send() {
        try {
            this.sender.send(this.target, new TransportMessage((Object)this.factory.createEvent()));
            this.logger.debug("SCM Event sent successful.");
        }
        catch (Exception e) {
            if (this.isStrict) {
                throw e;
            }
            this.logger.warn("Failed to send SCM event. Reason: {}", (Object)e.getMessage());
            this.logger.debug(e.getMessage(), (Throwable)e);
        }
    }
}

