/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client.event;

import java.net.URI;
import java.util.Map;
import org.ametiste.scm.messaging.data.event.Event;
import org.ametiste.scm.messaging.data.event.InstanceLifecycleEvent;
import org.ametiste.scm.messaging.sender.client.event.EventFactory;
import org.apache.commons.lang3.Validate;

public class StartupEventFactory
implements EventFactory {
    private String instanceId;
    private String version;
    private String nodeId;
    private URI uri;
    private Map<String, Object> properties;

    public StartupEventFactory() {
    }

    public StartupEventFactory(String instanceId, String version, Map<String, Object> properties) {
        this.instanceId = instanceId;
        this.version = version;
        this.properties = properties;
    }

    public StartupEventFactory(String instanceId, String version, String nodeId, URI uri, Map<String, Object> properties) {
        this.instanceId = instanceId;
        this.version = version;
        this.nodeId = nodeId;
        this.uri = uri;
        this.properties = properties;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Event createEvent() {
        this.validateState();
        return InstanceLifecycleEvent.builder().type(InstanceLifecycleEvent.Type.STARTUP).instanceId(this.instanceId).version(this.version).properties(this.properties).nodeId(this.nodeId).uri(this.uri).build();
    }

    private void validateState() {
        Validate.notBlank((CharSequence)this.instanceId, (String)"'instanceId' must be initialized and contains text", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.version, (String)"'version' must be initialized and contains text", (Object[])new Object[0]);
        Validate.isTrue((this.properties != null ? 1 : 0) != 0, (String)"'properties' must be initialized", (Object[])new Object[0]);
    }
}

