/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client.environment;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametiste.scm.messaging.sender.client.environment.Sanitizer;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class AppPropertiesAggregator {
    private final Sanitizer sanitizer = new Sanitizer();

    public Map<String, Object> aggregateProperties(Environment environment) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (environment != null) {
            result.put("profiles", environment.getActiveProfiles());
        }
        this.getPropertySources(environment).entrySet().stream().filter(entry -> entry.getValue() instanceof EnumerablePropertySource).forEach(entry -> {
            EnumerablePropertySource enumerable = (EnumerablePropertySource)entry.getValue();
            Map<String, Object> map = Arrays.stream(enumerable.getPropertyNames()).collect(Collectors.toMap(name -> name, name -> this.sanitizer.sanitize((String)name, enumerable.getProperty(name))));
            result.put((String)entry.getKey(), map);
        });
        return result;
    }

    private Map<String, PropertySource<?>> getPropertySources(Environment environment) {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = null;
        sources = environment != null && environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }
}

