/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client.environment;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class Sanitizer {
    public static final String SANITIZE_STRING = "******";
    private static final List<String> REGEX_PARTS = Arrays.asList("*", "$", "^", "+");
    private List<Pattern> keysToSanitize;

    public Sanitizer() {
        this.setKeysToSanitize("password", "secret", "key", "credentials");
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Validate.isTrue((keysToSanitize != null ? 1 : 0) != 0, (String)"KeysToSanitize must not be null", (Object[])new Object[0]);
        this.keysToSanitize = Arrays.stream(keysToSanitize).map(this::getPattern).collect(Collectors.toList());
    }

    public Object sanitize(String key, Object value) {
        if (value != null && this.keysToSanitize.stream().anyMatch(p -> p.matcher(key).matches())) {
            return SANITIZE_STRING;
        }
        return value;
    }

    private Pattern getPattern(String value) {
        if (this.isRegex(value)) {
            return Pattern.compile(value, 2);
        }
        return Pattern.compile(".*" + value + "$", 2);
    }

    private boolean isRegex(String value) {
        return REGEX_PARTS.stream().anyMatch(value::contains);
    }
}

