/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client.config;

import java.net.URI;
import java.net.URISyntaxException;
import org.ametiste.scm.messaging.sender.EventSender;
import org.ametiste.scm.messaging.sender.HttpEventSender;
import org.ametiste.scm.messaging.sender.client.config.HttpClientProperties;
import org.ametiste.scm.messaging.sender.client.config.InstanceInfoProperties;
import org.ametiste.scm.messaging.sender.client.environment.AppPropertiesAggregator;
import org.ametiste.scm.messaging.sender.client.event.EventFactory;
import org.ametiste.scm.messaging.sender.client.event.ShutdownEventFactory;
import org.ametiste.scm.messaging.sender.client.event.StartupEventFactory;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(value={"org.ametiste.scm.messaging.sender.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={HttpClientProperties.class, InstanceInfoProperties.class})
public class LifecycleEventsConfiguration {
    @Autowired
    private HttpClientProperties httpClientProps;
    @Autowired
    private InstanceInfoProperties instanceProps;
    @Autowired
    private Environment env;

    @Bean
    public HttpClient eventSenderHttpClient() {
        return HttpEventSender.createHttpClient((int)this.httpClientProps.getConnectTimeout(), (int)this.httpClientProps.getReadTimeout());
    }

    @Bean
    public EventSender eventSender() {
        return new HttpEventSender(this.eventSenderHttpClient());
    }

    @Bean
    public AppPropertiesAggregator propertiesAggregator() {
        return new AppPropertiesAggregator();
    }

    @Bean
    @Qualifier(value="startupEventFactory")
    public EventFactory startupEventFactory() throws URISyntaxException {
        StartupEventFactory factory = new StartupEventFactory();
        factory.setInstanceId(this.instanceProps.getInstanceId());
        factory.setVersion(this.instanceProps.getVersion());
        factory.setNodeId(this.instanceProps.getNodeId());
        factory.setUri(LifecycleEventsConfiguration.safeUri(this.instanceProps.getUri()));
        factory.setProperties(this.propertiesAggregator().aggregateProperties(this.env));
        return factory;
    }

    @Bean
    @Qualifier(value="shutdownEventFactory")
    public EventFactory shutdownEventFactory() throws URISyntaxException {
        ShutdownEventFactory factory = new ShutdownEventFactory();
        factory.setInstanceId(this.instanceProps.getInstanceId());
        factory.setVersion(this.instanceProps.getVersion());
        factory.setNodeId(this.instanceProps.getNodeId());
        factory.setUri(LifecycleEventsConfiguration.safeUri(this.instanceProps.getUri()));
        return factory;
    }

    private static URI safeUri(String uri) {
        return uri != null ? URI.create(uri) : null;
    }
}

