/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client.config;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.ametiste.scm.messaging.sender.EventSender;
import org.ametiste.scm.messaging.sender.client.EventSenderClient;
import org.ametiste.scm.messaging.sender.client.config.ClientProperties;
import org.ametiste.scm.messaging.sender.client.config.LifecycleEventsConfiguration;
import org.ametiste.scm.messaging.sender.client.event.EventFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"org.ametiste.scm.messaging.sender.client.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={LifecycleEventsConfiguration.class})
@Import(value={LifecycleEventsConfiguration.class})
@EnableConfigurationProperties(value={ClientProperties.class})
public class MessagingClientsConfiguration {
    @Autowired
    private ClientProperties clientProps;
    @Autowired
    private EventSender eventSender;
    @Autowired
    private EventFactory startupEventFactory;
    @Autowired
    private EventFactory shutdownEventFactory;

    @Bean
    @Qualifier(value="startupEventSenderClient")
    public EventSenderClient startupEventSenderClient() throws URISyntaxException {
        return new EventSenderClient(this.startupEventFactory, this.eventSender, MessagingClientsConfiguration.safeUri(this.clientProps.getTargetUri()), this.clientProps.isStrict());
    }

    @Bean
    @Qualifier(value="shutdownEventSenderClient")
    @ConditionalOnProperty(value={"org.ametiste.scm.messaging.sender.client.enabled"}, matchIfMissing=true)
    public EventSenderClient shutdownEventSenderClient() throws URISyntaxException {
        return new EventSenderClient(this.shutdownEventFactory, this.eventSender, MessagingClientsConfiguration.safeUri(this.clientProps.getTargetUri()), this.clientProps.isStrict());
    }

    @PostConstruct
    public void sendStartupEvent() throws URISyntaxException {
        if (this.startupEventSenderClient() != null) {
            this.startupEventSenderClient().send();
        }
    }

    @PreDestroy
    public void sendShutdownEvent() throws URISyntaxException {
        if (this.shutdownEventSenderClient() != null) {
            this.shutdownEventSenderClient().send();
        }
    }

    private static URI safeUri(String uri) {
        return uri != null ? URI.create(uri) : null;
    }
}

