/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.sender.client.config;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.ametiste.scm.messaging.sender.EventSender;
import org.ametiste.scm.messaging.sender.HttpEventSender;
import org.ametiste.scm.messaging.sender.client.EventSenderClient;
import org.ametiste.scm.messaging.sender.client.config.ClientProperties;
import org.ametiste.scm.messaging.sender.client.config.HttpClientProperties;
import org.ametiste.scm.messaging.sender.client.config.InstanceInfoProperties;
import org.ametiste.scm.messaging.sender.client.environment.AppPropertiesAggregator;
import org.ametiste.scm.messaging.sender.client.event.EventFactory;
import org.ametiste.scm.messaging.sender.client.event.ShutdownEventFactory;
import org.ametiste.scm.messaging.sender.client.event.StartupEventFactory;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(value={"org.ametiste.scm.messaging.sender.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={HttpClientProperties.class, InstanceInfoProperties.class, ClientProperties.class})
public class LifecycleEventSendConfiguration {
    @Autowired
    private HttpClientProperties httpClientProps;
    @Autowired
    private InstanceInfoProperties instanceProps;
    @Autowired
    private ClientProperties clientProps;
    @Autowired
    private Environment env;

    @Bean
    public HttpClient eventSenderHttpClient() {
        return HttpEventSender.createHttpClient((int)this.httpClientProps.getConnectTimeout(), (int)this.httpClientProps.getReadTimeout());
    }

    @Bean
    public EventSender eventSender() {
        return new HttpEventSender(this.eventSenderHttpClient());
    }

    @Bean
    public AppPropertiesAggregator propertiesAggregator() {
        return new AppPropertiesAggregator();
    }

    @Bean
    @Qualifier(value="startupEventFactory")
    public EventFactory startupEventFactory() throws URISyntaxException {
        return new StartupEventFactory(this.instanceProps.getInstanceId(), this.instanceProps.getVersion(), this.instanceProps.getNodeId(), new URI(this.instanceProps.getUri()), this.propertiesAggregator().aggregateProperties(this.env));
    }

    @Bean
    @Qualifier(value="shutdownEventFactory")
    public EventFactory shutdownEventFactory() throws URISyntaxException {
        return new ShutdownEventFactory(this.instanceProps.getInstanceId(), this.instanceProps.getVersion(), this.instanceProps.getNodeId(), new URI(this.instanceProps.getUri()));
    }

    @Bean
    @Qualifier(value="startupEventSenderClient")
    @ConditionalOnProperty(value={"org.ametiste.scm.messaging.sender.client.enabled"}, matchIfMissing=true)
    public EventSenderClient startupEventSenderClient() throws URISyntaxException {
        return new EventSenderClient(this.startupEventFactory(), this.eventSender(), new URI(this.clientProps.getTargetUri()), this.clientProps.isStrict());
    }

    @Bean
    @Qualifier(value="shutdownEventSenderClient")
    @ConditionalOnProperty(value={"org.ametiste.scm.messaging.sender.client.enabled"}, matchIfMissing=true)
    public EventSenderClient shutdownEventSenderClient() throws URISyntaxException {
        return new EventSenderClient(this.shutdownEventFactory(), this.eventSender(), new URI(this.clientProps.getTargetUri()), this.clientProps.isStrict());
    }

    @PostConstruct
    public void sendStartupEvent() throws URISyntaxException {
        if (this.startupEventSenderClient() != null) {
            this.startupEventSenderClient().send();
        }
    }

    @PreDestroy
    public void sendShutdownEvent() throws URISyntaxException {
        if (this.shutdownEventSenderClient() != null) {
            this.shutdownEventSenderClient().send();
        }
    }
}

