/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.messaging.receiver;

import java.util.Collection;
import org.ametiste.scm.messaging.data.transport.EventTransportMessage;
import org.ametiste.scm.messaging.data.transport.TransportMessage;
import org.ametiste.scm.messaging.transport.http.dto.EventDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventReceivingController {
    private final ApplicationEventPublisher publisher;

    @Autowired
    public EventReceivingController(ApplicationEventPublisher publisher) {
        Assert.notNull((Object)publisher, (String)"'publisher' must be initialized");
        this.publisher = publisher;
    }

    @RequestMapping(value={"/event-receiver"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void receiveEvents(@RequestBody Collection<TransportMessage<EventDTO>> events) {
        events.stream().map(m -> new EventTransportMessage(((EventDTO)m.getSource()).convert(), m.getExcludes())).forEach(arg_0 -> ((ApplicationEventPublisher)this.publisher).publishEvent(arg_0));
        events.stream().map(TransportMessage::getSource).map(EventDTO::convert).forEach(arg_0 -> ((ApplicationEventPublisher)this.publisher).publishEvent(arg_0));
    }
}

