/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.scm.coordinator.accessor;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.Application;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametiste.scm.coordinator.accessor.EventSubscribersFetcher;
import org.ametiste.scm.coordinator.accessor.FetchSubscribersException;
import org.apache.commons.lang3.Validate;

public class EurekaEventSubscribersFetcher
implements EventSubscribersFetcher {
    public static final String SUBSCRIBER_METADATA_FIELD = "eventSubscriber";
    public static final String EVENT_RECEIVER_URL_PATH_FIELD = "eventReceiverUrlPath";
    private final DiscoveryClient discoveryClient;

    public EurekaEventSubscribersFetcher(DiscoveryClient discoveryClient) {
        Validate.isTrue((discoveryClient != null ? 1 : 0) != 0, (String)"'discoveryClient' must be initialized", (Object[])new Object[0]);
        this.discoveryClient = discoveryClient;
    }

    public Collection<URI> fetchSubscribers() throws FetchSubscribersException {
        return this.registeredEventSubscribersStream().map(this::createReceiverEndpointUrl).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<URI> fetchSubscribers(String pattern) throws FetchSubscribersException {
        return this.registeredEventSubscribersStream().filter(i -> Pattern.matches(pattern, i.getAppName().toLowerCase())).map(this::createReceiverEndpointUrl).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<InstanceInfo> registeredEventSubscribersStream() {
        return this.discoveryClient.getApplications().getRegisteredApplications().stream().map(Application::getInstances).flatMap(Collection::stream).filter(i -> i.getMetadata().containsKey(SUBSCRIBER_METADATA_FIELD)).filter(i -> Boolean.valueOf((String)i.getMetadata().get(SUBSCRIBER_METADATA_FIELD)));
    }

    private URI createReceiverEndpointUrl(InstanceInfo info) {
        if (info.getHostName() != null && info.getMetadata().containsKey(EVENT_RECEIVER_URL_PATH_FIELD)) {
            return URI.create(String.format("http://%s:%d%s", info.getHostName(), info.getPort(), info.getMetadata().get(EVENT_RECEIVER_URL_PATH_FIELD)));
        }
        return null;
    }
}

