/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.tasklog.domain;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.ametiste.routine.mod.tasklog.domain.NoticeEntry;
import org.ametiste.routine.mod.tasklog.domain.OperationLog;

public class TaskLogEntry {
    private final UUID taskId;
    private final Instant creationTime;
    private final Instant executionStartTime;
    private final Instant completionTime;
    private final List<NoticeEntry> notices;
    private final String state;
    private final Map<String, String> properties;
    private final Collection<OperationLog> lines;

    public TaskLogEntry(UUID taskId, Instant creationTime, Instant executionStartTime, Instant completionTime, List<NoticeEntry> notices, String state, Map<String, String> properties, Collection<OperationLog> lines) {
        this.taskId = taskId;
        this.creationTime = creationTime;
        this.executionStartTime = executionStartTime;
        this.completionTime = completionTime;
        this.notices = notices;
        this.state = state;
        this.properties = properties;
        this.lines = Collections.unmodifiableCollection(lines);
    }

    public List<NoticeEntry> getNotices() {
        return this.notices;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Optional<Instant> getExecutionStartTime() {
        return Optional.ofNullable(this.executionStartTime);
    }

    public Optional<Instant> getCompletionTime() {
        return Optional.ofNullable(this.completionTime);
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public String getState() {
        return this.state;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<OperationLog> getLines() {
        return this.lines;
    }
}

