/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.tasklog.infrastructure.persistency.jpa;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.ametiste.metrics.annotations.Timeable;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.infrastructure.persistency.jpa.TaskDataSpecifications;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskPropertyData;
import org.ametiste.routine.mod.tasklog.domain.NoticeEntry;
import org.ametiste.routine.mod.tasklog.domain.OperationLog;
import org.ametiste.routine.mod.tasklog.domain.TaskLogEntry;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;
import org.ametiste.routine.mod.tasklog.infrastructure.persistency.jpa.JPATaskLogDataRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.transaction.annotation.Transactional;

public class SpringDataTaskLogRepository
implements TaskLogRepository {
    private final JPATaskLogDataRepository jpaTaskLogDataRepository;

    public SpringDataTaskLogRepository(JPATaskLogDataRepository jpaTaskLogDataRepository) {
        this.jpaTaskLogDataRepository = jpaTaskLogDataRepository;
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.count-active-tasks.timing")
    public long countActiveTasks() {
        return this.jpaTaskLogDataRepository.countTaskByStateIn(this.statesToString(Task.State.activeState));
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-entries.timing")
    public List<TaskLogEntry> findEntries() {
        throw new UnsupportedOperationException("Reimplemnt it as limited query.");
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-entry.timing")
    public TaskLogEntry findTaskLog(UUID taskId) {
        return this.processReflectedEntry((TaskData)this.jpaTaskLogDataRepository.findOne(taskId));
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-by-state.timing")
    public List<TaskLogEntry> findEntries(List<Task.State> states, int offset, int limit) {
        Specifications accumulator = Specifications.where((Specification)TaskDataSpecifications.hasState(states));
        return this.jpaTaskLogDataRepository.findAll((Specification)accumulator, (Pageable)new PageRequest(offset, limit)).getContent().stream().map(this::processReflectedEntry).collect(Collectors.toList());
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-by-state-and-props.timing")
    public List<TaskLogEntry> findEntries(List<Task.State> states, List<TaskProperty> properties, int offset, int limit) {
        return this.jpaTaskLogDataRepository.findAll(this.createStateAndPropsSpec(states, properties), (Pageable)new PageRequest(offset, limit)).getContent().stream().map(this::processReflectedEntry).collect(Collectors.toList());
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.count-by-state.timing")
    public int countByState(String byStatus) {
        return this.jpaTaskLogDataRepository.countTaskByState(byStatus);
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.count-by-state-and-props.timing")
    public long countByTaskState(List<Task.State> states, List<TaskProperty> properties) {
        return this.jpaTaskLogDataRepository.count(this.createStateAndPropsSpec(states, properties));
    }

    private List<String> statesToString(List<Task.State> states) {
        return states.stream().map(Enum::name).collect(Collectors.toList());
    }

    private TaskPropertyData propsToData(TaskProperty p) {
        TaskPropertyData data = new TaskPropertyData();
        data.setName(p.name());
        data.setValue(p.value());
        return data;
    }

    private NoticeEntry createNoticeEntry(OperationNoticeData notice) {
        return new NoticeEntry(notice.getCreationTime(), notice.getText());
    }

    private NoticeEntry createNoticeEntry(TaskNoticeData notice) {
        return new NoticeEntry(notice.getCreationTime(), notice.getText());
    }

    private TaskLogEntry processReflectedEntry(TaskData reflectedData) {
        return new TaskLogEntry(reflectedData.getId(), reflectedData.getCreationTime().toInstant(), reflectedData.getExecutionStartTime().toInstant(), reflectedData.getCompletionTime().toInstant(), reflectedData.getNotices().stream().map(this::createNoticeEntry).collect(Collectors.toList()), reflectedData.getState(), reflectedData.getProperties().stream().collect(Collectors.toMap(p -> p.getName(), p -> p.getValue())), reflectedData.getOperations().stream().map(x -> new OperationLog(x.getId(), x.getLabel(), x.getState(), x.getNotices().stream().map(this::createNoticeEntry).collect(Collectors.toList()), x.getProperties().stream().collect(Collectors.toMap(v -> v.getName(), v -> v.getValue())))).collect(Collectors.toList()));
    }

    private SpecificationAccumulator<TaskData> createStateAndPropsSpec(List<Task.State> states, List<TaskProperty> properties) {
        SpecificationAccumulator<TaskData> accumulator = new SpecificationAccumulator<TaskData>(Specifications.where((Specification)TaskDataSpecifications.hasState(states)));
        properties.stream().map(this::createPropSpec).forEach(accumulator::and);
        return accumulator;
    }

    private Specification<TaskData> createPropSpec(TaskProperty taskProperty) {
        if (taskProperty.name().equals(Task.CREATOR_PROPERTY_NAME)) {
            return TaskDataSpecifications.hasCreator((String)taskProperty.value());
        }
        if (taskProperty.name().equals(Task.SCHEME_PROPERTY_NAME)) {
            return TaskDataSpecifications.hasScheme((String)taskProperty.value());
        }
        return TaskDataSpecifications.hasProperty((TaskProperty)taskProperty);
    }

    private static class SpecificationAccumulator<T>
    implements Supplier<Specification<T>>,
    Specification<T> {
        private Specifications<T> accumulator;

        public SpecificationAccumulator(Specifications<T> accumulator) {
            this.accumulator = accumulator;
        }

        public void and(Specification<T> specification) {
            this.accumulator = this.accumulator.and(specification);
        }

        public void or(Specification<T> specification) {
            this.accumulator = this.accumulator.or(specification);
        }

        @Override
        public Specifications<T> get() {
            return this.accumulator;
        }

        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return this.accumulator.toPredicate(root, query, cb);
        }
    }
}

