/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.tasklog.interfaces.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.BasicTaskProperty;
import org.ametiste.routine.mod.tasklog.domain.NoticeEntry;
import org.ametiste.routine.mod.tasklog.domain.TaskLogEntry;
import org.ametiste.routine.mod.tasklog.domain.TaskLogNotFoundException;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;
import org.ametiste.routine.mod.tasklog.interfaces.web.resources.NoticeDTO;
import org.ametiste.routine.mod.tasklog.interfaces.web.resources.OperationLogDTO;
import org.ametiste.routine.mod.tasklog.interfaces.web.resources.TaskLogEntryContent;
import org.ametiste.routine.mod.tasklog.interfaces.web.resources.TaskLogEntryResource;
import org.ametiste.routine.mod.tasklog.interfaces.web.resources.TaskLogEntryResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/log"})
public class TaskLogController {
    @Autowired
    private TaskLogRepository taskLogRepository;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={TaskLogNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Requested Task Log Not Found")
    public void handleTaskLogNotFoundException(TaskLogNotFoundException e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Can't find requested task log.", (Throwable)e);
        }
    }

    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    public Map provideLogEntriesCount(@RequestParam(value="status") String[] byStatus) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String status : byStatus) {
            int entriesCount = this.taskLogRepository.countEntriesByStatus(status);
            counts.put(status, entriesCount);
        }
        return counts;
    }

    @RequestMapping(method={RequestMethod.GET})
    public TaskLogEntryResources provideLogEntries(@RequestParam(value="status", required=false) List<String> byStatus, @RequestParam(value="property", required=false) List<String> byProperty, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit) {
        List<Object> propertiesFilter = byProperty != null ? byProperty.stream().map(s -> s.split(":", 2)).map(a -> new BasicTaskProperty(a[0], a[1])).collect(Collectors.toList()) : Collections.emptyList();
        List<Object> states = byStatus != null ? byStatus.stream().map(Task.State::valueOf).collect(Collectors.toList()) : Collections.emptyList();
        ArrayList<TaskLogEntryResource> entryResources = new ArrayList<TaskLogEntryResource>();
        List<TaskLogEntry> entryList = byProperty == null && byStatus == null ? this.taskLogRepository.findEntries() : (byProperty != null ? this.taskLogRepository.findEntries(states, propertiesFilter, offset, limit) : this.taskLogRepository.findEntries(states, offset, limit));
        entryList.stream().map(this::assembleLogEntryResource).forEach(entryResources::add);
        TaskLogEntryResources resources = new TaskLogEntryResources(entryResources);
        resources.add(ControllerLinkBuilder.linkTo((Object)((Object)((TaskLogController)ControllerLinkBuilder.methodOn(TaskLogController.class, (Object[])new Object[0])).provideLogEntries(byStatus, byProperty, offset, limit))).withSelfRel());
        return resources;
    }

    @RequestMapping(value={"/task/{taskId}"}, method={RequestMethod.GET})
    public TaskLogEntryResource provideTaskLog(@PathVariable(value="taskId") UUID taskId) {
        TaskLogEntry taskLogEntry = this.taskLogRepository.findTaskLog(taskId);
        return this.assembleLogEntryResource(taskLogEntry);
    }

    private TaskLogEntryResource assembleLogEntryResource(TaskLogEntry taskLogEntry) {
        TaskLogEntryContent content = new TaskLogEntryContent(taskLogEntry.getTaskId(), taskLogEntry.getState(), taskLogEntry.getProperties(), taskLogEntry.getNotices().stream().map(this::createNoticeDTO).collect(Collectors.toList()), taskLogEntry.getLines().stream().map(o -> new OperationLogDTO(o.getOperationId(), o.getState(), o.getLine(), o.getNotices().stream().map(this::createNoticeDTO).collect(Collectors.toList()))).collect(Collectors.toList()));
        TaskLogEntryResource resource = new TaskLogEntryResource(content, new Link[0]);
        resource.add(ControllerLinkBuilder.linkTo((Object)((Object)((TaskLogController)ControllerLinkBuilder.methodOn(TaskLogController.class, (Object[])new Object[0])).provideTaskLog(taskLogEntry.getTaskId()))).withSelfRel());
        return resource;
    }

    private NoticeDTO createNoticeDTO(NoticeEntry o) {
        return new NoticeDTO(o.getTime(), o.getText());
    }
}

