/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.tasklog.infrastructure.persistency.memory;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.mod.tasklog.domain.TaskLogEntry;
import org.ametiste.routine.mod.tasklog.domain.TaskLogNotFoundException;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;

public class InMemoryTaskLogRepository
implements TaskLogRepository {
    private HashMap<UUID, TaskLogEntry> log = new HashMap();

    @Override
    public long countActiveTasks() {
        return this.log.values().stream().filter(e -> e.getState().equals(Task.State.PENDING.name()) || e.getState().equals(Task.State.EXECUTION.name())).count();
    }

    @Override
    public List<UUID> findNewTasks(long appendCount) {
        ArrayList<UUID> entries = new ArrayList<UUID>();
        for (TaskLogEntry logEntry : this.log.values()) {
            if (logEntry.getState().equals(Task.State.NEW.name())) {
                entries.add(logEntry.getTaskId());
            }
            if ((long)entries.size() != appendCount) continue;
            break;
        }
        return entries;
    }

    @Override
    public void saveTaskLog(TaskLogEntry taskLogEntry) {
        this.log.put(taskLogEntry.getTaskId(), taskLogEntry);
    }

    @Override
    public List<TaskLogEntry> findEntries() {
        return Collections.unmodifiableList(new ArrayList<TaskLogEntry>(this.log.values()));
    }

    @Override
    public TaskLogEntry findTaskLog(UUID taskId) {
        if (this.log.containsKey(taskId)) {
            return this.log.get(taskId);
        }
        throw new TaskLogNotFoundException("Can't find log for the task with the given id : " + taskId);
    }

    @Override
    public List<UUID> findActiveTasksAfterDate(Instant timePoint) {
        return this.log.values().stream().filter(e -> e.getExecutionStartTime().isPresent() && e.getExecutionStartTime().get().isBefore(timePoint)).filter(e -> e.getState().equals(Task.State.EXECUTION.name()) || e.getState().equals(Task.State.PENDING.name())).map(e -> e.getTaskId()).collect(Collectors.toList());
    }

    @Override
    public List<TaskLogEntry> findEntries(String byStatus, int offset, int limit) {
        return this.log.values().stream().filter(e -> e.getState().equals(byStatus)).collect(Collectors.toList());
    }

    @Override
    public List<TaskLogEntry> findEntries(List<Task.State> states, int offset, int limit) {
        return null;
    }

    @Override
    public List<TaskLogEntry> findEntries(List<Task.State> states, List<TaskProperty> properties, int offset, int limit) {
        return null;
    }

    @Override
    public int countEntriesByStatus(String byStatus) {
        return 0;
    }

    @Override
    public int countByTaskState(Task.State[] states, TaskProperty[] properties) {
        return 0;
    }

    @Override
    public int countByTaskState(Task.State[] states) {
        return 0;
    }
}

