/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.tasklog.infrastructure.persistency.jdbc;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.notices.Notice;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.infrastructure.persistency.ClosedTaskReflection;
import org.ametiste.routine.infrastructure.persistency.jdbc.reflection.JdbcTaskReflection;
import org.ametiste.routine.mod.tasklog.domain.NoticeEntry;
import org.ametiste.routine.mod.tasklog.domain.OperationLog;
import org.ametiste.routine.mod.tasklog.domain.TaskLogEntry;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTaskLogRepository
implements TaskLogRepository {
    private final String taskPropertiesTable = "ame_routine.ame_routine_task_property";
    private JdbcTemplate jdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String taskTable;
    private String operationTable;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setTaskTable(String taskTable) {
        this.taskTable = taskTable;
    }

    public void setOperationTable(String operationTable) {
        this.operationTable = operationTable;
    }

    @Override
    public long countActiveTasks() {
        long tasksCount = (Long)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(*) FROM %s WHERE state in ('EXECUTION', 'PENDING')", this.taskTable), Long.class);
        return tasksCount;
    }

    @Override
    public List<UUID> findNewTasks(long appendCount) {
        List newTasks = this.jdbcTemplate.queryForList(String.format("SELECT id FROM %s WHERE state = 'NEW' ORDER BY cr_time DESC LIMIT ?", this.taskTable), String.class, new Object[]{appendCount});
        return newTasks.stream().map(UUID::fromString).collect(Collectors.toList());
    }

    @Override
    public void saveTaskLog(TaskLogEntry taskLogEntry) {
    }

    @Override
    public List<TaskLogEntry> findEntries() {
        return new JdbcTaskReflection(this.taskTable, this.operationTable, this.jdbcTemplate).loadMultipleReflections(this::processReflectedEntry, 0, 100);
    }

    @Override
    public TaskLogEntry findTaskLog(UUID taskId) {
        JdbcTaskReflection jdbcTaskReflection = new JdbcTaskReflection(this.taskTable, this.operationTable, taskId, this.jdbcTemplate);
        return (TaskLogEntry)jdbcTaskReflection.processReflection(this::processReflectedEntry);
    }

    @Override
    public List<UUID> findActiveTasksAfterDate(Instant timePoint) {
        List tasks = this.jdbcTemplate.queryForList(String.format("SELECT id FROM %s WHERE execs_time < ? AND state in ('EXECUTION', 'PENDING')", this.taskTable), String.class, new Object[]{Timestamp.from(timePoint)});
        return tasks.stream().map(UUID::fromString).collect(Collectors.toList());
    }

    @Override
    public List<TaskLogEntry> findEntries(String byStatus, int offset, int limit) {
        return new JdbcTaskReflection(this.taskTable, this.operationTable, this.jdbcTemplate).loadMultipleReflections(this::processReflectedEntry, byStatus, offset, limit);
    }

    @Override
    public List<TaskLogEntry> findEntries(List<Task.State> states, int offset, int limit) {
        String findQuery = String.format("SELECT agregate FROM " + this.taskTable + " WHERE " + "   %s " + " ORDER BY cr_time DESC" + " LIMIT %s, %s ", this.createStateFilter(states), offset, limit);
        return new JdbcTaskReflection(this.taskTable, this.operationTable, this.jdbcTemplate).loadMultipleReflectionsAs(findQuery, this::processReflectedEntry);
    }

    @Override
    public List<TaskLogEntry> findEntries(List<Task.State> states, List<TaskProperty> properties, int offset, int limit) {
        String findQuery = String.format("SELECT agregate FROM " + this.taskTable + " JOIN " + "ame_routine.ame_routine_task_property" + " ON " + "   " + this.taskTable + ".id = " + "ame_routine.ame_routine_task_property" + ".task_id " + " WHERE " + "   %s " + "   %s " + " GROUP BY id " + " HAVING COUNT(id) = %s" + " ORDER BY cr_time DESC" + " LIMIT %s, %s ", this.createStateFilter(states), (states.size() > 0 ? "AND " : "") + this.createPropertiesFilter(properties), properties.size(), offset, limit);
        return new JdbcTaskReflection(this.taskTable, this.operationTable, this.jdbcTemplate).loadMultipleReflectionsAs(findQuery, this::processReflectedEntry);
    }

    @Override
    public int countEntriesByStatus(String byStatus) {
        int tasksCount = (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(id) FROM %s WHERE state = ?", this.taskTable), Integer.class, new Object[]{byStatus});
        return tasksCount;
    }

    @Override
    public int countByTaskState(Task.State[] states, TaskProperty[] properties) {
        String countQuery = String.format("SELECT COUNT(*) FROM ( SELECT id FROM " + this.taskTable + " JOIN " + "ame_routine.ame_routine_task_property" + " ON " + "   " + this.taskTable + ".id = " + "ame_routine.ame_routine_task_property" + ".task_id " + " WHERE " + "   %s " + "   %s " + " GROUP BY id " + " HAVING COUNT(id) = %s )", this.createStateFilter(Arrays.asList(states)), (states.length > 0 ? "AND " : "") + this.createPropertiesFilter(Arrays.asList(properties)), properties.length);
        return (Integer)this.jdbcTemplate.queryForObject(countQuery, Integer.class);
    }

    @Override
    public int countByTaskState(Task.State[] states) {
        int tasksCount = (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(id) FROM %s WHERE state in (%s)", this.taskTable, this.createStateFilter(Arrays.asList(states))), Integer.class);
        return tasksCount;
    }

    private NoticeEntry createNoticeEntry(Notice notice) {
        return new NoticeEntry(notice.creationTime(), notice.text());
    }

    private TaskLogEntry processReflectedEntry(ClosedTaskReflection.ReflectedTaskData reflectedData) {
        return new TaskLogEntry(reflectedData.taskId, reflectedData.creationTime, reflectedData.executionStartTime, reflectedData.completionTime, reflectedData.notices.stream().map(this::createNoticeEntry).collect(Collectors.toList()), reflectedData.state.name(), reflectedData.properties, reflectedData.operationFlare.stream().map(x -> new OperationLog(x.flashId(), x.flashLabel(), x.flashState(), x.flashNotices().stream().map(this::createNoticeEntry).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    private String createPropertiesFilter(List<TaskProperty> properties) {
        if (properties.isEmpty()) {
            return "";
        }
        return "ame_routine.ame_routine_task_property.name in (" + String.join((CharSequence)",", properties.stream().map(p -> "'" + p.name() + "'").collect(Collectors.toList())) + ") AND " + "ame_routine.ame_routine_task_property" + ".value in (" + String.join((CharSequence)",", properties.stream().map(p -> "'" + p.value() + "'").collect(Collectors.toList())) + ")";
    }

    private String createStateFilter(List<Task.State> states) {
        if (states.isEmpty()) {
            return "";
        }
        return "state in (" + String.join((CharSequence)",", states.stream().map(state -> "'" + state.name() + "'").collect(Collectors.toList())) + ")";
    }
}

