/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.tasklog.infrastructure.persistency.jpa;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.ametiste.metrics.annotations.Timeable;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.infrastructure.persistency.jpa.data.OperationNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData_;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskNoticeData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskPropertyData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskPropertyData_;
import org.ametiste.routine.mod.tasklog.domain.NoticeEntry;
import org.ametiste.routine.mod.tasklog.domain.OperationLog;
import org.ametiste.routine.mod.tasklog.domain.TaskLogEntry;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;
import org.ametiste.routine.mod.tasklog.infrastructure.persistency.jpa.JPATaskLogDataRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.transaction.annotation.Transactional;

public class SpringDataTaskLogRepository
implements TaskLogRepository {
    private final JPATaskLogDataRepository jpaTaskLogDataRepository;

    public SpringDataTaskLogRepository(JPATaskLogDataRepository jpaTaskLogDataRepository) {
        this.jpaTaskLogDataRepository = jpaTaskLogDataRepository;
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.count-active-tasks.timing")
    public long countActiveTasks() {
        return this.jpaTaskLogDataRepository.countTaskByStateIn(this.statesToString(Task.State.activeStatesList));
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-entries.timing")
    public List<TaskLogEntry> findEntries() {
        throw new UnsupportedOperationException("Reimplemnt it as limited query.");
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-entry.timing")
    public TaskLogEntry findTaskLog(UUID taskId) {
        return this.processReflectedEntry((TaskData)this.jpaTaskLogDataRepository.findOne(taskId));
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-active-after-date.timing")
    public List<UUID> findActiveTasksAfterDate(Instant timePoint) {
        return null;
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-by-state.timing")
    public List<TaskLogEntry> findEntries(List<Task.State> states, int offset, int limit) {
        Specifications accumulator = Specifications.where(TaskDataSpecifications.hasState(states));
        return this.jpaTaskLogDataRepository.findAll((Specification)accumulator, (Pageable)new PageRequest(offset, limit)).getContent().stream().map(this::processReflectedEntry).collect(Collectors.toList());
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.find-by-state-and-props.timing")
    public List<TaskLogEntry> findEntries(List<Task.State> states, List<TaskProperty> properties, int offset, int limit) {
        return this.jpaTaskLogDataRepository.findAll(this.createStateAndPropsSpec(states, properties), (Pageable)new PageRequest(offset, limit)).getContent().stream().map(this::processReflectedEntry).collect(Collectors.toList());
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.count-by-state.timing")
    public int countByState(String byStatus) {
        return this.jpaTaskLogDataRepository.countTaskByState(byStatus);
    }

    @Override
    @Transactional
    @Timeable(name="mods.task-log.infrastructure.persistency.task-repository.count-by-state-and-props.timing")
    public long countByTaskState(List<Task.State> states, List<TaskProperty> properties) {
        return this.jpaTaskLogDataRepository.count(this.createStateAndPropsSpec(states, properties));
    }

    private List<String> statesToString(List<Task.State> states) {
        return states.stream().map(Enum::name).collect(Collectors.toList());
    }

    private TaskPropertyData propsToData(TaskProperty p) {
        TaskPropertyData data = new TaskPropertyData();
        data.name = p.name();
        data.value = p.value();
        return data;
    }

    private NoticeEntry createNoticeEntry(OperationNoticeData notice) {
        return new NoticeEntry(notice.creationTime, notice.text);
    }

    private NoticeEntry createNoticeEntry(TaskNoticeData notice) {
        return new NoticeEntry(notice.creationTime, notice.text);
    }

    private TaskLogEntry processReflectedEntry(TaskData reflectedData) {
        return new TaskLogEntry(reflectedData.id, reflectedData.creationTime, reflectedData.executionStartTime, reflectedData.completionTime, reflectedData.notices.stream().map(this::createNoticeEntry).collect(Collectors.toList()), reflectedData.state, reflectedData.properties.stream().collect(Collectors.toMap(p -> p.name, p -> p.value)), reflectedData.operationData.stream().map(x -> new OperationLog(x.id, x.label, x.state, x.notices.stream().map(this::createNoticeEntry).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    private SpecificationAccumulator<TaskData> createStateAndPropsSpec(List<Task.State> states, List<TaskProperty> properties) {
        SpecificationAccumulator<TaskData> accumulator = new SpecificationAccumulator<TaskData>(Specifications.where(TaskDataSpecifications.hasState(states)));
        properties.stream().map(this::createPropSpec).forEach(accumulator::and);
        return accumulator;
    }

    private Specification<TaskData> createPropSpec(TaskProperty taskProperty) {
        if (taskProperty.name().equals(Task.CREATOR_PROPERTY_NAME)) {
            return TaskDataSpecifications.hasCreator(taskProperty.value());
        }
        if (taskProperty.name().equals(Task.SCHEME_PROPERTY_NAME)) {
            return TaskDataSpecifications.hasScheme(taskProperty.value());
        }
        return TaskDataSpecifications.hasProperty(taskProperty);
    }

    private static class SpecificationAccumulator<T>
    implements Supplier<Specification<T>>,
    Specification<T> {
        private Specifications<T> accumulator;

        public SpecificationAccumulator(Specifications<T> accumulator) {
            this.accumulator = accumulator;
        }

        public void and(Specification<T> specification) {
            this.accumulator = this.accumulator.and(specification);
        }

        public void or(Specification<T> specification) {
            this.accumulator = this.accumulator.or(specification);
        }

        @Override
        public Specifications<T> get() {
            return this.accumulator;
        }

        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return this.accumulator.toPredicate(root, query, cb);
        }
    }

    private static class TaskDataSpecifications {
        private TaskDataSpecifications() {
        }

        public static Specification<TaskData> hasScheme(String schemeId) {
            return (root, query, cb) -> cb.equal((Expression)root.get(TaskData_.schemeId), (Object)schemeId);
        }

        public static Specification<TaskData> hasCreator(String creatorId) {
            return (root, query, cb) -> cb.equal((Expression)root.get(TaskData_.creatorId), (Object)creatorId);
        }

        public static Specification<TaskData> hasProperty(TaskProperty taskProperty) {
            return (root, query, cb) -> {
                ListJoin join = root.join(TaskData_.properties);
                Path stringPath = root.get(TaskData_.state);
                return cb.and((Expression)cb.equal((Expression)join.get(TaskPropertyData_.name), (Object)taskProperty.name()), (Expression)cb.equal((Expression)join.get(TaskPropertyData_.value), (Object)taskProperty.value()));
            };
        }

        public static Specification<TaskData> hasState(List<Task.State> states) {
            return (root, query, cb) -> root.get(TaskData_.state).in((Collection)states.stream().map(Enum::name).collect(Collectors.toList()));
        }
    }
}

