/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.application.service;

import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.routine.infrastructure.protocol.taskpool.TaskPoolProtocol;
import org.ametiste.routine.mod.shredder.application.schema.ShreddingStaleTaskScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShreddingTaskService {
    private final ProtocolGatewayService protocolGatewayService;
    private final List<String> staleStates;
    private final int staleThresholdValue;
    private final ChronoUnit staleThresholdUnit;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ShreddingTaskService(ProtocolGatewayService protocolGatewayService, List<String> staleStates, int staleThresholdValue, ChronoUnit staleThresholdUnit) {
        this.protocolGatewayService = protocolGatewayService;
        this.staleStates = staleStates;
        this.staleThresholdValue = staleThresholdValue;
        this.staleThresholdUnit = staleThresholdUnit;
    }

    public void issueShreddingTask() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Issue shredding tasks with staleStates: {}, threshold: {} {}", new Object[]{this.staleStates, this.staleThresholdValue, this.staleThresholdUnit});
        }
        ProtocolGateway gateway = this.protocolGatewayService.createGateway("mod-shredder", Collections.emptyMap());
        try {
            ((TaskPoolProtocol)gateway.session(TaskPoolProtocol.class)).issueTask(ShreddingStaleTaskScheme.class, p -> {
                p.staleStates(this.staleStates);
                p.staleThresholdValue(this.staleThresholdValue);
                p.staleThresholdUnit(this.staleThresholdUnit);
            });
        }
        finally {
            gateway.release();
        }
    }
}

