/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.application.operation;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.sdk.protocol.operation.ParamsProtocol;

public class ShreddingParams
implements ParamsProtocol {
    public static final String PARAM_STALE_THRESHOLD_VALUE = "mod-shredding.op.shredding.staleThreshold";
    public static final String PARAM_STALE_THRESHOLD_UNIT = "mod-shredding.op.shredding.staleThresholdUnit";
    public static final String PARAM_STALE_STATES = "mod-shredding.op.shredding.staleStates";
    public static final List<String> DEFAULT_STALE_STATES = Collections.singletonList(Task.State.DONE.name());
    public static final int DEFAULT_STALE_THRESHOLD_VALUE = 12;
    public static final ChronoUnit DEFAULT_STALE_THRESHOLD_UNIT = ChronoUnit.HOURS;
    private final Map<String, String> properties = new HashMap<String, String>();

    public Integer threshold() {
        return ShreddingParams.mayBe(PARAM_STALE_THRESHOLD_VALUE, this.properties, Integer::valueOf, 12);
    }

    public ChronoUnit unit() {
        return ShreddingParams.mayBe(PARAM_STALE_THRESHOLD_UNIT, this.properties, ChronoUnit::valueOf, DEFAULT_STALE_THRESHOLD_UNIT);
    }

    public List<String> staleStates() {
        return ShreddingParams.mayBe(PARAM_STALE_STATES, this.properties, this::splitAsCSList, DEFAULT_STALE_STATES);
    }

    public void fromMap(Map<String, String> params) {
        this.properties.putAll(params);
    }

    public Map<String, String> asMap() {
        return this.properties;
    }

    public <T extends ParamsProtocol> void proxy(T params) {
        params.fromMap(this.asMap());
    }

    private static <K, V> Optional<V> mayBe(K key, Map<K, V> in) {
        return Optional.ofNullable(in.get(key));
    }

    private static <K, V, T> T mayBe(K key, Map<K, V> in, Function<V, T> as, T else_) {
        return ShreddingParams.mayBe(key, in).map(as).orElse(else_);
    }

    private List<String> splitAsCSList(String s) {
        return Arrays.asList(s.split(","));
    }

    public void staleStates(List<String> staleStates) {
        this.properties.put(PARAM_STALE_STATES, String.join((CharSequence)",", staleStates));
    }

    public void staleThresholdValue(int staleThresholdValue) {
        this.properties.put(PARAM_STALE_THRESHOLD_VALUE, Integer.toString(staleThresholdValue));
    }

    public void staleThresholdUnit(ChronoUnit staleThresholdUnit) {
        this.properties.put(PARAM_STALE_THRESHOLD_UNIT, staleThresholdUnit.name());
    }

    public static ShreddingParams createFromMap(Map<String, String> params) {
        ShreddingParams backlogParams = new ShreddingParams();
        backlogParams.fromMap(params);
        return backlogParams;
    }
}

