/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.configuration;

import java.time.temporal.ChronoUnit;
import java.util.List;
import org.ametiste.routine.mod.shredder.application.operation.DirectShreddingParams;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="org.ametiste.routine.mod.shredder")
public class ModShredderProperties {
    private StaleThreshold staleThreshold = new StaleThreshold();
    private List<String> staleStates = DirectShreddingParams.DEFAULT_STALE_STATES;
    private boolean disableSessionOptions = false;

    public StaleThreshold getStaleThreshold() {
        return this.staleThreshold;
    }

    public void setStaleThreshold(StaleThreshold staleThreshold) {
        this.staleThreshold = staleThreshold;
    }

    public List<String> getStaleStates() {
        return this.staleStates;
    }

    public void setStaleStates(List<String> staleStates) {
        this.staleStates = staleStates;
    }

    public boolean isDisableSessionOptions() {
        return this.disableSessionOptions;
    }

    public void setDisableSessionOptions(boolean disableSessionOptions) {
        this.disableSessionOptions = disableSessionOptions;
    }

    public static class StaleThreshold {
        private int staleThresholdValue = 12;
        private ChronoUnit staleThresholdUnit = DirectShreddingParams.DEFAULT_STALE_THRESHOLD_UNIT;

        public int getValue() {
            return this.staleThresholdValue;
        }

        public ChronoUnit getUnit() {
            return this.staleThresholdUnit;
        }

        public void setValue(int staleThresholdValue) {
            this.staleThresholdValue = staleThresholdValue;
        }

        public void setUnit(String staleThresholdUnit) {
            this.staleThresholdUnit = ChronoUnit.valueOf(staleThresholdUnit);
        }
    }
}

