/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.application.operation;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.protocol.gateway.SessionOption;
import org.ametiste.routine.infrastructure.protocol.taskpool.TaskPoolProtocol;
import org.ametiste.routine.mod.shredder.application.operation.ShreddingParams;
import org.ametiste.routine.sdk.operation.OperationExecutor;
import org.ametiste.routine.sdk.operation.OperationFeedback;
import org.ametiste.routine.sdk.protocol.modreport.ModReportProtocol;
import org.ametiste.routine.sdk.protocol.modreport.ReportForm;

public class ShreddingStaleTaskExecutor
implements OperationExecutor {
    public void execOperation(OperationFeedback feedback, ProtocolGateway protocolGateway) {
        ShreddingParams shreddingParams = (ShreddingParams)protocolGateway.session(ShreddingParams.class);
        Integer threshold = shreddingParams.threshold();
        ChronoUnit unit = shreddingParams.unit();
        List<String> staleStates = shreddingParams.staleStates();
        List<SessionOption> sessionOptions = ShreddingStaleTaskExecutor.resolveSessionOptions(shreddingParams);
        long removedTasksCount = ((TaskPoolProtocol)protocolGateway.session(TaskPoolProtocol.class, sessionOptions)).removeTasks(staleStates, Instant.now().minus(threshold.intValue(), unit));
        Consumer<ReportForm> reportBuilder = rb -> {
            rb.type("SHREDDING_STALE_REPORT");
            rb.data("remove.tasks.count", Long.toString(removedTasksCount));
        };
        if (sessionOptions.contains(SessionOption.STATS)) {
            long lastInvocTime = protocolGateway.sessionOption(TaskPoolProtocol.class, SessionOption.STATS).queryLong("session.last.invocation.time");
            reportBuilder = reportBuilder.andThen(rb -> rb.data("remove.time.taken", Long.toString(lastInvocTime)));
        }
        ((ModReportProtocol)protocolGateway.session(ModReportProtocol.class)).submitReport(reportBuilder);
    }

    private static <K, V> Optional<V> mayBe(K key, Map<K, V> in) {
        return Optional.ofNullable(in.get(key));
    }

    private static <K, V, T> T mayBe(K key, Map<K, V> in, Function<V, T> as, T else_) {
        return ShreddingStaleTaskExecutor.mayBe(key, in).map(as).orElse(else_);
    }

    private static List<SessionOption> resolveSessionOptions(ShreddingParams params) {
        return params.disableSessionOptions() ? Collections.emptyList() : Collections.singletonList(SessionOption.STATS);
    }

    private List<String> splitAsCSList(String s) {
        return Arrays.asList(s.split(","));
    }
}

