/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.configuration;

import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.routine.mod.shredder.application.action.ShreddingAction;
import org.ametiste.routine.mod.shredder.application.service.ShreddingTaskService;
import org.ametiste.routine.mod.shredder.configuration.ModShredderProperties;
import org.ametiste.routine.mod.shredder.mod.ModShredder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="org.ametiste.routine.mod.shredder", name={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={ModShredderProperties.class})
public class ModShredderConfiguration {
    public static final String PREFIX = "org.ametiste.routine.mod.shredder";
    @Autowired
    private ModShredderProperties props;
    @Autowired
    private ProtocolGatewayService protocolGatewayService;

    @Bean
    public ShreddingTaskService shreddingTaskService() {
        return new ShreddingTaskService(this.protocolGatewayService, this.props.getStaleStates(), this.props.getStaleThreshold().getValue(), this.props.getStaleThreshold().getUnit());
    }

    @Bean
    public ShreddingAction shreddingAction() {
        return new ShreddingAction(this.shreddingTaskService());
    }

    @Bean
    public ModShredder modShredderGateway() {
        return new ModShredder();
    }
}

