/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.application.service;

import java.util.HashMap;
import java.util.List;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.routine.sdk.protocol.taskpool.TaskPoolProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShreddingTaskService {
    private final ProtocolGatewayService protocolGatewayService;
    private final List<String> staleStates;
    private final int staleThresholdValue;
    private final String staleThresholdUnit;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ShreddingTaskService(ProtocolGatewayService protocolGatewayService, List<String> staleStates, int staleThresholdValue, String staleThresholdUnit) {
        this.protocolGatewayService = protocolGatewayService;
        this.staleStates = staleStates;
        this.staleThresholdValue = staleThresholdValue;
        this.staleThresholdUnit = staleThresholdUnit;
    }

    public void issueShreddingTask() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Issue shredding tasks with staleStates: {}, threshold: {} {}", new Object[]{this.staleStates, this.staleThresholdValue, this.staleThresholdUnit});
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("mod-shredding.op.shredding.staleThreshold", Integer.toString(this.staleThresholdValue));
        p.put("mod-shredding.op.shredding.staleThresholdUnit", this.staleThresholdUnit);
        p.put("mod-shredding.op.shredding.staleStates", String.join((CharSequence)",", this.staleStates));
        ((TaskPoolProtocol)this.protocolGatewayService.createGateway("mod-shredder").session(TaskPoolProtocol.class)).issueTask("mod-shredder-scheme-shredding-stale-tasks", p);
    }
}

