/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.shredder.application.operation;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.protocol.gateway.SessionOption;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.sdk.operation.OperationExecutor;
import org.ametiste.routine.sdk.operation.OperationFeedback;
import org.ametiste.routine.sdk.protocol.modreport.ModReportProtocol;
import org.ametiste.routine.sdk.protocol.taskpool.TaskPoolProtocol;
import org.springframework.stereotype.Component;

@Component(value="mod-shredder-op-shredding-stale")
public class ShreddingStaleTaskOperationExecutor
implements OperationExecutor {
    public static final String NAME = "mod-shredder-op-shredding-stale";
    public static final String PARAM_STALE_THRESHOLD_VALUE = "mod-shredding.op.shredding.staleThreshold";
    public static final String PARAM_STALE_THRESHOLD_UNIT = "mod-shredding.op.shredding.staleThresholdUnit";
    public static final String PARAM_STALE_STATES = "mod-shredding.op.shredding.staleStates";
    public static final List<String> DEFAULT_STALE_STATES = Arrays.asList(Task.State.DONE.name());
    public static final int DEFAULT_STALE_THRESHOLD_VALUE = 12;
    public static final ChronoUnit DEFAULT_STALE_THRESHOLD_UNIT = ChronoUnit.HOURS;

    public void execOperation(UUID operationId, Map<String, String> properties, OperationFeedback feedback, ProtocolGateway protocolGateway) {
        Integer threshold = ShreddingStaleTaskOperationExecutor.mayBe(PARAM_STALE_THRESHOLD_VALUE, properties, Integer::valueOf, 12);
        ChronoUnit unit = ShreddingStaleTaskOperationExecutor.mayBe(PARAM_STALE_THRESHOLD_UNIT, properties, ChronoUnit::valueOf, DEFAULT_STALE_THRESHOLD_UNIT);
        List<String> staleStates = ShreddingStaleTaskOperationExecutor.mayBe(PARAM_STALE_STATES, properties, this::splitAsCSList, DEFAULT_STALE_STATES);
        long removedTasksCount = ((TaskPoolProtocol)protocolGateway.session(TaskPoolProtocol.class, new SessionOption[]{SessionOption.STATS})).removeTasks(staleStates, Instant.now().minus(threshold.intValue(), unit));
        long lastInvocTime = protocolGateway.sessionOption(TaskPoolProtocol.class, SessionOption.STATS).queryLong("session.last.invocation.time");
        ((ModReportProtocol)protocolGateway.session(ModReportProtocol.class)).submitReport(rb -> {
            rb.type("SHREDDING_STALE_REPORT");
            rb.data("remove.time.taken", Long.toString(lastInvocTime));
            rb.data("remove.tasks.count", Long.toString(removedTasksCount));
        });
    }

    private static <K, V> Optional<V> mayBe(K key, Map<K, V> in) {
        return Optional.ofNullable(in.get(key));
    }

    private static <K, V, T> T mayBe(K key, Map<K, V> in, Function<V, T> as, T else_) {
        return ShreddingStaleTaskOperationExecutor.mayBe(key, in).map(as).orElse(else_);
    }

    private List<String> splitAsCSList(String s) {
        return Arrays.asList(s.split(","));
    }
}

