/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.dispenser.application.service;

import java.util.List;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.ExecutionLine;
import org.ametiste.routine.domain.task.ExecutionOrder;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.mod.dispenser.application.service.OperationReservationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultOperationReservationService
implements OperationReservationService {
    public static final int DEFAULT_RESERVATION_LIMIT = 10;
    private final int reservationLimit;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TaskRepository taskRepository;

    public DefaultOperationReservationService(TaskRepository taskRepository) {
        this(taskRepository, 10);
    }

    public DefaultOperationReservationService(TaskRepository taskRepository, int reservationLimit) {
        this.taskRepository = taskRepository;
        this.reservationLimit = reservationLimit;
    }

    @Override
    @Transactional
    public List<ExecutionLine> reserveOperationsExecution(int reservationCount) {
        List tasks = this.taskRepository.findTasksByState(Task.State.NEW, reservationCount);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reserved tasks count: " + tasks.size());
        }
        List<ExecutionLine> executionLines = tasks.stream().map(Task::prepareExecution).map(ExecutionOrder::executionLines).flatMap(l -> l.stream()).collect(Collectors.toList());
        tasks.forEach(arg_0 -> ((TaskRepository)this.taskRepository).saveTask(arg_0));
        return executionLines;
    }
}

