/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.dispenser.interfaces.web;

import java.util.List;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.ExecutionLine;
import org.ametiste.routine.mod.dispenser.application.service.OperationReservationService;
import org.ametiste.routine.mod.dispenser.interfaces.web.data.ReservationIssueDTO;
import org.ametiste.routine.mod.dispenser.interfaces.web.data.ReservationOrderDTO;
import org.ametiste.routine.mod.dispenser.interfaces.web.data.ReservedTaskDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dispense"})
public class DispenseController {
    @Autowired
    private OperationReservationService operationReservationService;

    @RequestMapping(method={RequestMethod.POST})
    public ReservationOrderDTO reserveTasks(@RequestBody ReservationIssueDTO reservationIssue) {
        List<ExecutionLine> executionLines = this.operationReservationService.reserveOperationsExecution(reservationIssue.getMaxReservationCount());
        List<ReservedTaskDTO> collect = executionLines.stream().map(l -> new ReservedTaskDTO(l.operationId().toString(), l.line(), l.properties())).collect(Collectors.toList());
        return new ReservationOrderDTO(collect);
    }
}

