/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.backlog.infrastructure;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ametiste.routine.mod.backlog.domain.Backlog;
import org.ametiste.routine.mod.backlog.domain.BacklogRepository;

public class MemoryBacklogRepository
implements BacklogRepository {
    private Map<String, Backlog> backlogs = new ConcurrentHashMap<String, Backlog>();

    public MemoryBacklogRepository(List<Backlog> backlogs) {
        backlogs.forEach(this::save);
    }

    @Override
    public List<Backlog> loadAll() {
        return new ArrayList<Backlog>(this.backlogs.values());
    }

    @Override
    public Backlog loadBacklogOf(String taskSchemeName) {
        return this.backlogs.get(taskSchemeName);
    }

    @Override
    public void save(Backlog backlog) {
        this.backlogs.put(backlog.boundTaskScheme(), backlog);
    }
}

