/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.backlog.configuration;

import java.util.Map;
import java.util.Optional;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.infrastructure.mod.ModRepository;
import org.ametiste.routine.mod.backlog.domain.RenewSchemeExecutor;
import org.ametiste.routine.mod.backlog.infrastructure.BacklogPopulationStrategiesRegistry;
import org.ametiste.routine.mod.backlog.infrastructure.BacklogPopulationStrategy;
import org.ametiste.routine.mod.backlog.infrastructure.BacklogTaskGateway;
import org.ametiste.routine.mod.backlog.infrastructure.DefaultRenewSchemeExecutor;
import org.ametiste.routine.mod.backlog.infrastructure.MemoryBacklogPopulationStrategiesRegistry;
import org.ametiste.routine.sdk.mod.DataGateway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RenewSchemeExecutorConfiguration {
    @Autowired
    private Map<String, BacklogPopulationStrategy> backlogPopulationStrategies;
    @Autowired
    private TaskIssueService taskIssueService;
    @Autowired
    private ModRepository modRepository;

    @Bean
    public RenewSchemeExecutor renewSchemeExecutor() {
        return new DefaultRenewSchemeExecutor(this.backlogPopulationStrategiesRegistry(), new BacklogTaskGateway(this.taskIssueService), new DataGateway(){

            public void storeModData(String name, String value) {
                RenewSchemeExecutorConfiguration.this.modRepository.saveModProperty("mod-backlog", name, value);
            }

            public void storeModData(String name, Integer value) {
                RenewSchemeExecutorConfiguration.this.modRepository.saveModProperty("mod-backlog", name, Integer.toString(value));
            }

            public void storeModData(String name, Long value) {
                RenewSchemeExecutorConfiguration.this.modRepository.saveModProperty("mod-backlog", name, Long.toString(value));
            }

            public void storeModData(String name, Boolean value) {
                RenewSchemeExecutorConfiguration.this.modRepository.saveModProperty("mod-backlog", name, Boolean.toString(value));
            }

            public Optional<String> loadModData(String name) {
                return RenewSchemeExecutorConfiguration.this.modRepository.loadModProperty("mod-backlog", name);
            }

            public Optional<Integer> loadModDataInt(String name) {
                return Optional.ofNullable(RenewSchemeExecutorConfiguration.this.modRepository.loadModProperty("mod-backlog", name).map(Integer::valueOf).orElse(null));
            }

            public Optional<Long> loadModDataLong(String name) {
                return Optional.ofNullable(RenewSchemeExecutorConfiguration.this.modRepository.loadModProperty("mod-backlog", name).map(Long::valueOf).orElse(null));
            }

            public Optional<Boolean> loadModDataBool(String name) {
                return Optional.ofNullable(RenewSchemeExecutorConfiguration.this.modRepository.loadModProperty("mod-backlog", name).map(Boolean::valueOf).orElse(null));
            }
        });
    }

    @Bean
    public BacklogPopulationStrategiesRegistry backlogPopulationStrategiesRegistry() {
        return new MemoryBacklogPopulationStrategiesRegistry(this.backlogPopulationStrategies);
    }
}

