/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.backlog.configuration;

import java.util.ArrayList;
import java.util.List;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.mod.backlog.application.action.BacklogRenewAction;
import org.ametiste.routine.mod.backlog.application.operation.BacklogRenewOperationExecutor;
import org.ametiste.routine.mod.backlog.application.service.BacklogRenewService;
import org.ametiste.routine.mod.backlog.domain.Backlog;
import org.ametiste.routine.mod.backlog.domain.BacklogRepository;
import org.ametiste.routine.mod.backlog.infrastructure.MemoryBacklogRepository;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;
import org.ametiste.routine.sdk.operation.OperationExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="org.ametiste.routine", name={"mod.backlog.enabled"}, matchIfMissing=true)
public class BacklogModConfiguration {
    @Autowired
    private TaskLogRepository taskLogRepository;
    @Autowired
    private TaskIssueService taskIssueService;
    @Autowired(required=false)
    private List<Backlog> backlogs = new ArrayList<Backlog>();

    @Bean(name={"routine::mod::backlog::renewOperation"})
    public OperationExecutor backlogRenewOperationExecutor() {
        return new BacklogRenewOperationExecutor();
    }

    @Bean
    public BacklogRenewService backlogRenewService() {
        return new BacklogRenewService(this.taskLogRepository, this.taskIssueService);
    }

    @Bean
    public BacklogRepository backlogRepository() {
        return new MemoryBacklogRepository(this.backlogs);
    }

    @Bean
    public BacklogRenewAction backlogRenewAction() {
        return new BacklogRenewAction(this.backlogRepository(), this.backlogRenewService());
    }
}

