/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.backlog.application.service;

import java.util.Arrays;
import java.util.Collections;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.mod.backlog.domain.Backlog;
import org.ametiste.routine.mod.tasklog.domain.TaskLogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklogRenewService {
    private final TaskLogRepository taskLogRepository;
    private final TaskIssueService taskIssueService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BacklogRenewService(TaskLogRepository taskLogRepository, TaskIssueService taskIssueService) {
        this.taskLogRepository = taskLogRepository;
        this.taskIssueService = taskIssueService;
    }

    public void renewBy(Backlog backlog) {
        if (this.hasActiveTasksFromBacklog(backlog.boundTaskScheme())) {
            this.logger.debug("Backlog population skiped, has active tasks: {}", (Object)backlog.boundTaskScheme());
            return;
        }
        this.taskIssueService.issueTask("routine::mod::backlog::renewTaskScheme", Collections.singletonMap("schemeName", backlog.boundTaskScheme()), "mod-backlog:meta");
    }

    private boolean hasActiveTasksFromBacklog(String taskSchemeName) {
        long activeCount = this.taskLogRepository.countByTaskState(Task.State.activeStatesList, Arrays.asList(new TaskProperty(Task.SCHEME_PROPERTY_NAME, taskSchemeName), new TaskProperty(Task.CREATOR_PROPERTY_NAME, "mod-backlog")));
        return activeCount > 0L;
    }
}

