/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.mod.backlog.application.operation;

import java.util.Map;
import java.util.UUID;
import org.ametiste.routine.mod.backlog.domain.Backlog;
import org.ametiste.routine.mod.backlog.domain.BacklogRepository;
import org.ametiste.routine.mod.backlog.domain.RenewScheme;
import org.ametiste.routine.mod.backlog.domain.RenewSchemeExecutor;
import org.ametiste.routine.sdk.operation.OperationExecutor;
import org.ametiste.routine.sdk.operation.OperationFeedback;
import org.springframework.beans.factory.annotation.Autowired;

public class BacklogRenewOperationExecutor
implements OperationExecutor {
    public static final String NAME = "routine::mod::backlog::renewOperation";
    @Autowired
    private BacklogRepository backlogRepository;
    @Autowired
    private RenewSchemeExecutor renewSchemeExecutor;

    public void execOperation(UUID operationId, Map<String, String> properties, OperationFeedback feedback) {
        feedback.operationStarted("Starting renew operation.");
        Backlog backlog = this.backlogRepository.loadBacklogOf(properties.get("schemeName"));
        RenewScheme renewScheme = backlog.createRenewScheme();
        this.backlogRepository.save(backlog);
        this.renewSchemeExecutor.executeRenewScheme(renewScheme);
        feedback.operationSucceed();
    }
}

