/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.printer.scheme;

import java.util.Collections;
import java.util.Map;
import org.ametiste.routine.domain.scheme.AbstractTaskScheme;
import org.ametiste.routine.domain.scheme.TaskCreationRejectedBySchemeException;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.springframework.stereotype.Component;

@Component(value="printer-eg-task")
public class PrintTaskScheme
extends AbstractTaskScheme {
    public static final String NAME = "printer-eg-task";
    public static final String ALLOWED_CREATOR = "mod-backlog";

    protected void verifyCreationRequest(Map<String, String> schemeParams, String creatorIdentifier) throws TaskCreationRejectedBySchemeException {
        if (!creatorIdentifier.equals(ALLOWED_CREATOR)) {
            throw new TaskCreationRejectedBySchemeException("Unexpected creator identifier for task scheme 'printer-eg-task' expected 'mod-backlog' but '" + creatorIdentifier + "' given.");
        }
    }

    protected void fulfillOperations(Task task, Map<String, String> schemeParams) {
        task.addProperty(new TaskProperty("printer-eg.task.number", schemeParams.getOrDefault("task.number", "[none]")));
        task.addProperty(new TaskProperty("printer-eg.task.out", schemeParams.getOrDefault("task.out", "[none]")));
        task.addOperation("print-operation", Collections.singletonMap("out", schemeParams.getOrDefault("out", "[none]") + "::operation-1"));
        task.addOperation("print-operation", Collections.singletonMap("out", schemeParams.getOrDefault("out", "[none]") + "::operation-2"));
        task.addOperation("print-operation", Collections.singletonMap("out", schemeParams.getOrDefault("out", "[none]") + "::operation-3"));
        task.addOperation("print-operation", Collections.singletonMap("out", schemeParams.getOrDefault("out", "[none]") + "::operation-4"));
    }
}

