/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.printer.backlog;

import java.util.HashMap;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.routine.mod.backlog.infrastructure.BacklogPopulationStrategy;
import org.ametiste.routine.sdk.mod.ModDataClient;
import org.ametiste.routine.sdk.mod.TaskPoolClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="printer-eg-task-population")
public class PrintTaskPopulationStrategy
implements BacklogPopulationStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${org.ametiste.routine.eg.printer.populationCount:1000}")
    private int populationCount;

    public void populate(ProtocolGateway gateway) {
        TaskPoolClient tasks = new TaskPoolClient(gateway);
        ModDataClient data = new ModDataClient(gateway);
        int issuedTasksCount = data.loadModDataInt("backlog-print-tasks-count").orElse(0);
        this.logger.debug("Create task entries from backlog: " + issuedTasksCount);
        int i = 0;
        while (i < this.populationCount) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("task.number", Integer.toString(issuedTasksCount));
            params.put("task.out", "I am task #" + issuedTasksCount);
            tasks.issueTask("printer-eg-task", params);
            ++i;
            ++issuedTasksCount;
        }
        data.storeModData("backlog-print-tasks-count", Integer.valueOf(issuedTasksCount));
    }
}

