/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.protocol.taskpool;

import java.util.Map;
import java.util.UUID;
import org.ametiste.metrics.annotations.Timeable;
import org.ametiste.metrics.annotations.composite.Timeables;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.infrastructure.protocol.taskpool.DirectTaskPoolProtocolMetrics;
import org.ametiste.routine.sdk.mod.TaskPoolProtocol;

public class DirectTaskPoolProtocol
implements TaskPoolProtocol,
DirectTaskPoolProtocolMetrics {
    private final String clientId;
    private final TaskIssueService taskIssueService;

    public DirectTaskPoolProtocol(String clientId, TaskIssueService taskIssueService) {
        this.clientId = clientId;
        this.taskIssueService = taskIssueService;
    }

    @Timeables(value={@Timeable(name="core.infrastructure.protocol.task-pool.overall.issue-task.timing"), @Timeable(name="core.infrastructure.protocol.task-pool.clients", nameSuffixExpression="target.clientId + '.issue-task.timing'")})
    public UUID issueTask(String taskScheme, Map<String, String> params) {
        return this.taskIssueService.issueTask(taskScheme, params, this.clientId);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }
}

