/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.protocol.moddata;

import java.util.Optional;
import org.ametiste.metrics.annotations.Timeable;
import org.ametiste.metrics.annotations.composite.Timeables;
import org.ametiste.routine.domain.ModRepository;
import org.ametiste.routine.infrastructure.protocol.moddata.DirectModDataProtocolMetrics;
import org.ametiste.routine.sdk.mod.ModDataProtocol;

public class DirectModDataProtocol
implements ModDataProtocol,
DirectModDataProtocolMetrics {
    private final String clientId;
    private final ModRepository modRepository;

    public DirectModDataProtocol(String clientId, ModRepository modRepository) {
        this.clientId = clientId;
        this.modRepository = modRepository;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Timeables(value={@Timeable(name="core.infrastructure.protocol.direct-mod-data.overall.load.timing"), @Timeable(name="core.infrastructure.protocol.direct-mod-data.clients", nameSuffixExpression="target.clientId + '.load.timing'")})
    public Optional<String> loadData(String name) {
        return this.modRepository.loadModProperty(this.clientId, name);
    }

    @Timeables(value={@Timeable(name="core.infrastructure.protocol.direct-mod-data.overall.store.timing"), @Timeable(name="core.infrastructure.protocol.direct-mod-data.clients", nameSuffixExpression="target.clientId + '.store.timing'")})
    public void storeData(String name, String value) {
        this.modRepository.saveModProperty(this.clientId, name, value);
    }
}

