/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.execution;

import java.util.Map;
import java.util.UUID;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.metrics.annotations.Timeable;
import org.ametiste.routine.application.service.execution.ExecutionFeedback;
import org.ametiste.routine.application.service.execution.OperationExecutionGateway;
import org.ametiste.routine.infrastructure.execution.DefaultOperationFeedbackController;
import org.ametiste.routine.infrastructure.protocol.ProtocolGatewayService;
import org.ametiste.routine.sdk.operation.OperationExecutorFactory;
import org.ametiste.routine.sdk.operation.OperationFeedback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationExecutionGateway
implements OperationExecutionGateway {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, OperationExecutorFactory> operationExecutors;
    private final ProtocolGatewayService protocolGatewayservice;

    public DefaultOperationExecutionGateway(Map<String, OperationExecutorFactory> operationExecutors, ProtocolGatewayService protocolGatewayservice) {
        this.operationExecutors = operationExecutors;
        this.protocolGatewayservice = protocolGatewayservice;
    }

    @Override
    @Timeable(name="core.infrastructure.execution.local-gateway.timing")
    public void executeOperation(UUID operationId, String operationExecLine, Map<String, String> properties, ExecutionFeedback feedback) {
        if (!this.operationExecutors.containsKey(operationExecLine)) {
            throw new IllegalStateException("Can't find operation executor for: " + operationExecLine);
        }
        DefaultOperationFeedbackController feedbackController = new DefaultOperationFeedbackController(feedback, operationId);
        ProtocolGateway protocolGateway = this.protocolGatewayservice.createGateway(operationExecLine);
        feedback.operationStarted(operationId);
        try {
            this.operationExecutors.get(operationExecLine).createExecutor().execOperation(operationId, properties, (OperationFeedback)feedbackController, protocolGateway);
        }
        catch (Exception e) {
            this.logger.error("Error during task operation execution.", (Throwable)e);
            feedback.operationFailed(operationId, "Operation failed on execution.");
            return;
        }
        feedback.operationDone(operationId);
    }
}

