/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.domain.task;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.ametiste.domain.DomainStateReflector;
import org.ametiste.routine.domain.task.ExecutionLine;
import org.ametiste.routine.domain.task.ExecutionOrder;
import org.ametiste.routine.domain.task.Operation;
import org.ametiste.routine.domain.task.notices.Notice;
import org.ametiste.routine.domain.task.properties.BasicTaskProperty;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.domain.task.reflect.OperationFlare;
import org.ametiste.routine.domain.task.reflect.TaskLens;
import org.ametiste.routine.domain.task.reflect.TaskReflection;

public class Task
implements DomainStateReflector<TaskReflection> {
    public static String SCHEME_PROPERTY_NAME = "task.scheme";
    public static String CREATOR_PROPERTY_NAME = "created.by";
    private State inState;
    private UUID id;
    private Instant creationTime;
    private Instant executionStartTime;
    private Instant completionTime;
    private final List<Notice> notices = new ArrayList<Notice>();
    private final Map<UUID, Operation> operations = new HashMap<UUID, Operation>();
    private final ArrayList<Operation> operationsOrder = new ArrayList();
    private final Map<String, TaskProperty> properties = new HashMap<String, TaskProperty>();
    private final TaskReflection reflection = new ReflectedTask();

    public Task() {
        this.id = UUID.randomUUID();
        this.inState = State.NEW;
        this.creationTime = Instant.now();
    }

    public Task(TaskReflection reflection) {
        reflection.reflect(this.reflection);
    }

    public UUID entityId() {
        return this.id;
    }

    public void addOperation(String operationLabel, Map<String, String> properties) {
        this.inState.canBeModified();
        Operation operation = new Operation(operationLabel, properties);
        this.operations.put(operation.id, operation);
        this.operationsOrder.add(operation);
    }

    public void addProperty(TaskProperty property) {
        this.properties.put(property.name(), property);
    }

    public boolean hasProperty(TaskProperty property) {
        TaskProperty taskProperty = this.properties.get(property.name());
        return taskProperty == null && taskProperty.getClass().isAssignableFrom(property.getClass()) ? false : taskProperty.equalsTo(property);
    }

    public ExecutionOrder prepareExecution() {
        this.prepareTaskExecution();
        List<ExecutionLine> orderLines = this.operationsOrder.stream().map(Operation::prepareExecution).collect(Collectors.toList());
        return new ExecutionOrder(this.id, orderLines);
    }

    public void noticeOperation(UUID operationId, String message) {
        this.invokeOnOperation(operationId, o -> o.addNotice(message));
    }

    public void completeOperation(UUID operationId) {
        this.inState.canCompleteOperation();
        this.invokeOnOperation(operationId, Operation::complete);
        this.checkIsTaskCompleted();
    }

    public void terminateOperation(UUID operationId) {
        this.inState.canCompleteOperation();
        this.invokeOnOperation(operationId, Operation::terminate);
        this.checkIsTaskCompleted();
    }

    public void executeOperation(UUID operationId) {
        this.inState.canUpdateOperation();
        this.invokeOnOperation(operationId, Operation::execute);
        if (this.inState != State.EXECUTION) {
            this.inState = State.EXECUTION;
        }
    }

    public List<UUID> terminate(String message) {
        this.completeTask(State.TERMINATED);
        this.notices.add(new Notice(message));
        List<Operation> toBeterminated = this.operations.values().stream().filter(o -> o.state == Operation.State.EXECUTION).collect(Collectors.toList());
        toBeterminated.forEach(o -> {
            o.addNotice(message);
            o.terminate();
        });
        List<UUID> terminated = toBeterminated.stream().map(Operation::id).collect(Collectors.toList());
        return terminated;
    }

    public void reflectAs(TaskReflection domainReflection) {
        this.reflection.reflect(domainReflection);
    }

    public void flareTo(Supplier<TaskLens> taskLensSupplier) {
        taskLensSupplier.get();
    }

    private void invokeOnOperation(UUID operationId, Consumer<Operation> operationConsumer) {
        if (!this.operations.containsKey(operationId)) {
            throw new IllegalArgumentException("Task does not own operation with the given id: " + operationId.toString());
        }
        operationConsumer.accept(this.operations.get(operationId));
    }

    private void checkIsTaskCompleted() {
        for (Operation op : this.operations.values()) {
            if (!op.isNotDone()) continue;
            return;
        }
        if (this.operations.values().stream().filter(Operation::isTerminated).findFirst().isPresent()) {
            this.completeTask(State.TERMINATED);
        } else {
            this.completeTask(State.DONE);
        }
    }

    private void prepareTaskExecution() {
        this.inState.canBeExecuted();
        this.inState = State.PENDING;
        this.executionStartTime = Instant.now();
    }

    private void completeTask(State state) {
        state.canBeFinal();
        this.inState.canBeCompleted();
        this.completionTime = Instant.now();
        this.inState = state;
    }

    private class ReflectedTask
    implements TaskReflection {
        private ReflectedTask() {
        }

        @Override
        public void flareTaskId(UUID taskId) {
            Task.this.id = taskId;
        }

        @Override
        public void flareTaskState(State flareState) {
            Task.this.inState = flareState;
        }

        @Override
        public void flareOperation(OperationFlare operationFlare) {
            Operation flared = Operation.createByFlare(operationFlare);
            Task.this.operationsOrder.add(flared);
            Task.this.operations.put(operationFlare.flashId(), flared);
        }

        @Override
        public void flareProperty(String name, String value) {
            Task.this.properties.put(name, new BasicTaskProperty(name, value));
        }

        @Override
        public void flareTaskTimes(Instant creationTime, Instant executionStartTime, Instant completionTime) {
            Task.this.creationTime = creationTime;
            Task.this.executionStartTime = executionStartTime;
            Task.this.completionTime = completionTime;
        }

        @Override
        public void flareNotice(Notice notice) {
            Task.this.notices.add(notice);
        }

        @Override
        public void reflect(TaskReflection reflection) {
            reflection.flareTaskId(Task.this.id);
            reflection.flareTaskState(Task.this.inState);
            reflection.flareTaskTimes(Task.this.creationTime, Task.this.executionStartTime, Task.this.completionTime);
            Task.this.notices.forEach(reflection::flareNotice);
            Task.this.operationsOrder.forEach(x -> reflection.flareOperation(new OperationFlare(x.id, x.operationLabel, x.properties, x.state.name(), x.notices)));
            Task.this.properties.values().forEach(p -> reflection.flareProperty(p.name(), p.value()));
        }
    }

    public static enum State {
        NEW{

            @Override
            void canCompleteOperation() {
                throw new IllegalStateException("Task new and operation can't be completed.");
            }

            @Override
            void canUpdateOperation() {
                throw new IllegalStateException("Task new and operations can't be updated yet.");
            }
        }
        ,
        EXECUTION{

            @Override
            void canUpdateOperation() {
            }

            @Override
            void canBeExecuted() {
                throw new IllegalStateException("Task already executing.");
            }

            @Override
            void canBeModified() {
                throw new IllegalStateException("Task already executing and can't be modified.");
            }
        }
        ,
        PENDING{

            @Override
            void canBeModified() {
                throw new IllegalStateException("Task already pending and can't be modified.");
            }

            @Override
            void canUpdateOperation() {
            }

            @Override
            void canBeExecuted() {
                throw new IllegalStateException("Task already executing.");
            }
        }
        ,
        TERMINATED{

            @Override
            void canBeExecuted() {
                throw new IllegalStateException("Task already done.");
            }

            @Override
            void canBeModified() {
                throw new IllegalStateException("Task already done and can't be modified.");
            }

            @Override
            void canCompleteOperation() {
                throw new IllegalStateException("Task already done and operation can't be completed.");
            }

            @Override
            void canUpdateOperation() {
                throw new IllegalStateException("Task already done.");
            }

            @Override
            void canBeCompleted() {
                throw new IllegalStateException("Task already done.");
            }

            @Override
            void canBeFinal() {
            }
        }
        ,
        DONE{

            @Override
            void canBeExecuted() {
                throw new IllegalStateException("Task already done.");
            }

            @Override
            void canUpdateOperation() {
                throw new IllegalStateException("Task already done.");
            }

            @Override
            void canBeModified() {
                throw new IllegalStateException("Task already done and can't be modified.");
            }

            @Override
            void canCompleteOperation() {
                throw new IllegalStateException("Task already done and operation can't be completed.");
            }

            @Override
            void canBeCompleted() {
                throw new IllegalStateException("Task already done.");
            }

            @Override
            void canBeFinal() {
            }
        };

        @Deprecated
        public static State[] activeStates;
        public static List<State> activeStatesList;

        void canBeExecuted() {
        }

        void canBeModified() {
        }

        void canBeCompleted() {
        }

        void canCompleteOperation() {
        }

        void canUpdateOperation() {
        }

        void canBeFinal() {
            throw new IllegalStateException("State '" + this.name() + "' can't be a final state.");
        }

        static {
            activeStates = new State[]{NEW, PENDING, EXECUTION};
            activeStatesList = Arrays.asList(activeStates);
        }
    }
}

