/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.domain.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametiste.routine.domain.task.ExecutionLine;
import org.ametiste.routine.domain.task.notices.Notice;
import org.ametiste.routine.domain.task.reflect.OperationFlare;

public class Operation {
    UUID id;
    String operationLabel;
    final Map<String, String> properties;
    State state;
    List<Notice> notices;

    Operation(String operationLabel, Map<String, String> properties) {
        this(UUID.randomUUID(), operationLabel, properties, State.NEW, Collections.emptyList());
    }

    Operation(UUID id, String label, Map<String, String> properties, String state, List<Notice> notices) {
        this(id, label, properties, State.valueOf(state), notices);
    }

    Operation(UUID id, String label, Map<String, String> properties, State state, List<Notice> notices) {
        this.id = id;
        this.operationLabel = label;
        this.properties = properties;
        this.state = state;
        this.notices = new ArrayList<Notice>(notices);
    }

    UUID id() {
        return this.id;
    }

    void complete() {
        this.state = State.DONE;
    }

    void terminate() {
        this.state = State.TERMINATED;
    }

    void execute() {
        this.state = State.EXECUTION;
    }

    void addNotice(String text) {
        this.notices.add(new Notice(text));
    }

    ExecutionLine prepareExecution() {
        this.state = State.PENDING;
        return new ExecutionLine(this.id, this.operationLabel, this.properties);
    }

    boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    boolean isNotDone() {
        return this.state == State.EXECUTION || this.state == State.PENDING || this.state == State.NEW;
    }

    public static Operation createByFlare(OperationFlare flare) {
        return new Operation(flare.flashId(), flare.flashLabel(), flare.flashProperties(), flare.flashState(), flare.flashNotices());
    }

    static enum State {
        NEW,
        PENDING,
        EXECUTION,
        DONE,
        TERMINATED;

    }
}

