/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.application.service.issue;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametiste.routine.application.service.TaskAppEvenets;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.domain.scheme.TaskScheme;
import org.ametiste.routine.domain.scheme.TaskSchemeException;
import org.ametiste.routine.domain.scheme.TaskSchemeRepository;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.domain.task.properties.TaskPropertiesRegistry;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.sdk.application.service.issue.constraints.IssueConstraint;

public class DefaultTaskIssueService
implements TaskIssueService {
    private TaskRepository taskRepository;
    private TaskPropertiesRegistry taskPropertiesRegistry;
    private TaskSchemeRepository taskSchemeRepository;
    private final TaskAppEvenets taskAppEvenets;
    private final List<IssueConstraint> issueConstraints;

    public DefaultTaskIssueService(TaskRepository taskRepository, TaskPropertiesRegistry taskPropertiesRegistry, TaskSchemeRepository taskSchemeRepository, TaskAppEvenets taskAppEvenets, List<IssueConstraint> issueConstraints) {
        this.taskRepository = taskRepository;
        this.taskSchemeRepository = taskSchemeRepository;
        this.taskAppEvenets = taskAppEvenets;
        this.issueConstraints = issueConstraints;
    }

    @Override
    public UUID issueTask(String taskSchemeName, Map<String, String> params, String creatorIdenifier) {
        Task task;
        TaskScheme taskScheme = this.taskSchemeRepository.findTaskScheme(taskSchemeName);
        try {
            task = taskScheme.createTask(params, creatorIdenifier);
        }
        catch (TaskSchemeException e) {
            throw new RuntimeException("Task creation error", e);
        }
        task.addProperty(new TaskProperty(Task.SCHEME_PROPERTY_NAME, taskSchemeName));
        task.addProperty(new TaskProperty(Task.CREATOR_PROPERTY_NAME, creatorIdenifier));
        this.taskRepository.saveTask(task);
        this.taskAppEvenets.taskIssued(task.entityId());
        return task.entityId();
    }
}

