/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.application.service.execution;

import java.util.UUID;
import org.ametiste.domain.AggregateInstant;
import org.ametiste.routine.application.service.TaskAppEvenets;
import org.ametiste.routine.application.service.execution.ExecutionFeedback;
import org.ametiste.routine.application.service.execution.OperationExecutionGateway;
import org.ametiste.routine.application.service.execution.TaskExecutionService;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskExecutionService
implements TaskExecutionService,
ExecutionFeedback {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TaskRepository taskRepository;
    private final TaskAppEvenets taskAppEvenets;
    private OperationExecutionGateway operationExecutionGateway;

    public DefaultTaskExecutionService(TaskRepository taskRepository, TaskAppEvenets taskAppEvenets, OperationExecutionGateway operationExecutionGateway) {
        this.taskRepository = taskRepository;
        this.taskAppEvenets = taskAppEvenets;
        this.operationExecutionGateway = operationExecutionGateway;
    }

    @Override
    public void executeTask(UUID taskId) {
        AggregateInstant.create((Object)taskId, this.taskRepository::findTask, this.taskRepository::saveTask).action(t -> this.logger.debug("Executing task : {} ", (Object)t.entityId())).action(Task::prepareExecution).consume(this.taskAppEvenets::taskPended).consume(o -> this.logger.debug("Pass execution order to operations service: {}", o.executionLines())).done();
    }

    @Override
    public void completeTask(UUID taskId, String withMessage) {
    }

    @Override
    public void operationStarted(UUID operationId) {
        this.taskInstantForOperation(operationId).action(Task::executeOperation, (Object)operationId).done();
    }

    @Override
    public void operationDone(UUID operationId) {
        this.taskInstantForOperation(operationId).action(Task::completeOperation, (Object)operationId).done();
    }

    @Override
    public void operationStarted(UUID operationId, String withMessage) {
        this.taskInstantForOperation(operationId).action(Task::noticeOperation, (Object)operationId, (Object)withMessage).action(Task::executeOperation, (Object)operationId).done();
    }

    @Override
    public void operationDone(UUID operationId, String withMessage) {
        this.taskInstantForOperation(operationId).action(Task::noticeOperation, (Object)operationId, (Object)withMessage).action(Task::completeOperation, (Object)operationId).done();
    }

    @Override
    public void operationNotice(UUID operationId, String noticeMessage) {
        this.taskInstantForOperation(operationId).action(Task::noticeOperation, (Object)operationId, (Object)noticeMessage).done();
    }

    @Override
    public void operationFailed(UUID operationId, String withMessage) {
        this.taskInstantForOperation(operationId).action(Task::noticeOperation, (Object)operationId, (Object)withMessage).action(Task::terminateOperation, (Object)operationId).done();
    }

    private AggregateInstant<UUID, Task> taskInstantForOperation(UUID operationId) {
        return AggregateInstant.create((Object)operationId, this.taskRepository::findTaskByOperationId, this.taskRepository::saveTask);
    }
}

